package biz.turnonline.ecosystem.widget.product;

import biz.turnonline.ecosystem.widget.product.presenter.EditProductPresenter;
import biz.turnonline.ecosystem.widget.product.presenter.EditProductPresenter_Factory;
import biz.turnonline.ecosystem.widget.product.presenter.ProductsPresenter;
import biz.turnonline.ecosystem.widget.product.presenter.ProductsPresenter_Factory;
import biz.turnonline.ecosystem.widget.product.view.EditProductView;
import biz.turnonline.ecosystem.widget.product.view.EditProductView_Factory;
import biz.turnonline.ecosystem.widget.product.view.ProductsView;
import biz.turnonline.ecosystem.widget.product.view.ProductsView_Factory;
import biz.turnonline.ecosystem.widget.shared.AddressLookupListener;
import biz.turnonline.ecosystem.widget.shared.AppEventBus;
import biz.turnonline.ecosystem.widget.shared.AppEventBus_Factory;
import biz.turnonline.ecosystem.widget.shared.Configuration;
import biz.turnonline.ecosystem.widget.shared.rest.account.AccountStewardFacade;
import biz.turnonline.ecosystem.widget.shared.rest.bill.BillFacade;
import biz.turnonline.ecosystem.widget.shared.rest.billing.ProductBillingFacade;
import biz.turnonline.ecosystem.widget.shared.rest.payment.PaymentProcessorFacade;
import biz.turnonline.ecosystem.widget.shared.rest.search.SearchFacade;
import biz.turnonline.ecosystem.widget.shared.ui.ScaffoldBreadcrumb;
import com.google.gwt.activity.shared.ActivityManager;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import dagger.internal.DoubleCheck;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerProductComponent implements ProductComponent {
  private Provider<AccountStewardFacade> provideContactFacadeProvider;

  private Provider<ProductBillingFacade> provideProductBillingProvider;

  private Provider<SearchFacade> provideSearchFacadeProvider;

  private Provider<BillFacade> provideBillFacadeProvider;

  private Provider<PaymentProcessorFacade> providePaymentProcessorProvider;

  private Provider<Configuration> provideConfigurationProvider;

  private Provider<AppEventBus> appEventBusProvider;

  private Provider<PlaceHistoryMapper> providePlaceHistoryMapperProvider;

  private Provider<PlaceHistoryHandler.Historian> provideHistorianProvider;

  private Provider<PlaceController> providePlaceControllerProvider;

  private Provider<PlaceHistoryHandler> providePlaceHistoryHandlerProvider;

  private Provider<ScaffoldBreadcrumb> provideProductsBreadcrumbProvider;

  private Provider<ProductsView> productsViewProvider;

  private Provider<ProductsPresenter.IView> provideProductsViewProvider;

  private Provider<ProductsPresenter> productsPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideEditProductBreadcrumbProvider;

  private Provider<AddressLookupListener> provideAddressLookupListenerProvider;

  private Provider<EditProductView> editProductViewProvider;

  private Provider<EditProductPresenter.IView> provideEditProductViewProvider;

  private Provider<EditProductPresenter> editProductPresenterProvider;

  private Provider<ProductController> productControllerProvider;

  private Provider<ActivityMapper> provideActivityMapperProvider;

  private Provider<ActivityManager> provideActivityManagerProvider;

  private DaggerProductComponent() {

    initialize();
  }

  public static Builder builder() {
    return new Builder();
  }

  public static ProductComponent create() {
    return new Builder().build();
  }

  @SuppressWarnings("unchecked")
  private void initialize() {
    this.provideContactFacadeProvider = DoubleCheck.provider(ProductModule_ProvideContactFacadeFactory.create());
    this.provideProductBillingProvider = DoubleCheck.provider(ProductModule_ProvideProductBillingFactory.create());
    this.provideSearchFacadeProvider = DoubleCheck.provider(ProductModule_ProvideSearchFacadeFactory.create());
    this.provideBillFacadeProvider = DoubleCheck.provider(ProductModule_ProvideBillFacadeFactory.create());
    this.providePaymentProcessorProvider = DoubleCheck.provider(ProductModule_ProvidePaymentProcessorFactory.create());
    this.provideConfigurationProvider = DoubleCheck.provider(ProductModule_ProvideConfigurationFactory.create());
    this.appEventBusProvider = DoubleCheck.provider(AppEventBus_Factory.create(provideContactFacadeProvider, provideProductBillingProvider, provideSearchFacadeProvider, provideBillFacadeProvider, providePaymentProcessorProvider, provideConfigurationProvider));
    this.providePlaceHistoryMapperProvider = DoubleCheck.provider(ProductModule_ProvidePlaceHistoryMapperFactory.create());
    this.provideHistorianProvider = DoubleCheck.provider(ProductModule_ProvideHistorianFactory.create());
    this.providePlaceControllerProvider = DoubleCheck.provider(ProductModule_ProvidePlaceControllerFactory.create((Provider) appEventBusProvider));
    this.providePlaceHistoryHandlerProvider = DoubleCheck.provider(ProductModule_ProvidePlaceHistoryHandlerFactory.create(providePlaceHistoryMapperProvider, provideHistorianProvider, providePlaceControllerProvider, (Provider) appEventBusProvider));
    this.provideProductsBreadcrumbProvider = DoubleCheck.provider(ProductModule_ProvideProductsBreadcrumbFactory.create(providePlaceControllerProvider));
    this.productsViewProvider = ProductsView_Factory.create(provideProductsBreadcrumbProvider);
    this.provideProductsViewProvider = DoubleCheck.provider((Provider) productsViewProvider);
    this.productsPresenterProvider = ProductsPresenter_Factory.create(provideProductsViewProvider, providePlaceControllerProvider);
    this.provideEditProductBreadcrumbProvider = DoubleCheck.provider(ProductModule_ProvideEditProductBreadcrumbFactory.create(providePlaceControllerProvider));
    this.provideAddressLookupListenerProvider = DoubleCheck.provider(ProductModule_ProvideAddressLookupListenerFactory.create(provideConfigurationProvider));
    this.editProductViewProvider = EditProductView_Factory.create(providePlaceControllerProvider, provideEditProductBreadcrumbProvider, provideAddressLookupListenerProvider);
    this.provideEditProductViewProvider = DoubleCheck.provider((Provider) editProductViewProvider);
    this.editProductPresenterProvider = EditProductPresenter_Factory.create(provideEditProductViewProvider, providePlaceControllerProvider);
    this.productControllerProvider = ProductController_Factory.create(productsPresenterProvider, editProductPresenterProvider);
    this.provideActivityMapperProvider = DoubleCheck.provider((Provider) productControllerProvider);
    this.provideActivityManagerProvider = DoubleCheck.provider(ProductModule_ProvideActivityManagerFactory.create(provideActivityMapperProvider, (Provider) appEventBusProvider));
  }

  @Override
  public AppEventBus getEventBus() {
    return appEventBusProvider.get();}

  @Override
  public PlaceHistoryHandler placeHistoryHandler() {
    return providePlaceHistoryHandlerProvider.get();}

  @Override
  public ActivityManager getActivityManager() {
    return provideActivityManagerProvider.get();}

  public static final class Builder {
    private Builder() {
    }

    public ProductComponent build() {
      return new DaggerProductComponent();
    }
  }
}
