/*
 *  Copyright (c) 2020 TurnOnline.biz s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package biz.turnonline.ecosystem.widget.shared.ui;

import com.google.gwt.i18n.client.NumberFormat;
import gwt.material.design.client.ui.MaterialTextBox;

/**
 * @author <a href="mailto:pohorelec@turnonlie.biz">Jozef Pohorelec</a>
 */
public class PriceTextBox
        extends MaterialTextBox
{
    public void setValue( Double price, String currency )
    {
        setValue( format( price, currency ) );
    }

    private String format( Double price, String currency )
    {
        price = price != null ? price : 0D;
        return currency == null ? price.toString() : NumberFormat.getCurrencyFormat( currency ).format( price );
    }
}
