package biz.turnonline.ecosystem.widget.bill;

import biz.turnonline.ecosystem.widget.bill.presenter.BillsPresenter;
import biz.turnonline.ecosystem.widget.bill.presenter.BillsPresenter_Factory;
import biz.turnonline.ecosystem.widget.bill.presenter.EditBillPresenter;
import biz.turnonline.ecosystem.widget.bill.presenter.EditBillPresenter_Factory;
import biz.turnonline.ecosystem.widget.bill.view.BillsView;
import biz.turnonline.ecosystem.widget.bill.view.BillsView_Factory;
import biz.turnonline.ecosystem.widget.bill.view.EditBillView;
import biz.turnonline.ecosystem.widget.bill.view.EditBillView_Factory;
import biz.turnonline.ecosystem.widget.shared.AddressLookupListener;
import biz.turnonline.ecosystem.widget.shared.AppEventBus;
import biz.turnonline.ecosystem.widget.shared.AppEventBus_Factory;
import biz.turnonline.ecosystem.widget.shared.Configuration;
import biz.turnonline.ecosystem.widget.shared.rest.account.AccountStewardFacade;
import biz.turnonline.ecosystem.widget.shared.rest.bill.BillFacade;
import biz.turnonline.ecosystem.widget.shared.rest.billing.ProductBillingFacade;
import biz.turnonline.ecosystem.widget.shared.rest.search.SearchFacade;
import biz.turnonline.ecosystem.widget.shared.ui.ScaffoldBreadcrumb;
import com.google.gwt.activity.shared.ActivityManager;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import dagger.internal.DoubleCheck;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerBillComponent implements BillComponent {
  private Provider<AccountStewardFacade> provideContactFacadeProvider;

  private Provider<ProductBillingFacade> provideProductBillingProvider;

  private Provider<SearchFacade> provideSearchFacadeProvider;

  private Provider<BillFacade> provideBillFacadeProvider;

  private Provider<Configuration> provideConfigurationProvider;

  private Provider<AppEventBus> appEventBusProvider;

  private Provider<PlaceController> providePlaceControllerProvider;

  private Provider<PlaceHistoryHandler> providePlaceHistoryHandlerProvider;

  private Provider<ScaffoldBreadcrumb> provideBillsBreadcrumbProvider;

  private Provider<BillsView> billsViewProvider;

  private Provider<BillsPresenter.IView> provideBillsViewProvider;

  private Provider<BillsPresenter> billsPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideEditBillBreadcrumbProvider;

  private Provider<AddressLookupListener> provideAddressLookupListenerProvider;

  private Provider<EditBillView> editBillViewProvider;

  private Provider<EditBillPresenter.IView> provideEditBillViewProvider;

  private Provider<EditBillPresenter> editBillPresenterProvider;

  private Provider<BillController> billControllerProvider;

  private Provider<ActivityMapper> provideActivityMapperProvider;

  private Provider<ActivityManager> provideActivityManagerProvider;

  private DaggerBillComponent() {

    initialize();
  }

  public static Builder builder() {
    return new Builder();
  }

  public static BillComponent create() {
    return new Builder().build();
  }

  @SuppressWarnings("unchecked")
  private void initialize() {
    this.provideContactFacadeProvider = DoubleCheck.provider(BillModule_ProvideContactFacadeFactory.create());
    this.provideProductBillingProvider = DoubleCheck.provider(BillModule_ProvideProductBillingFactory.create());
    this.provideSearchFacadeProvider = DoubleCheck.provider(BillModule_ProvideSearchFacadeFactory.create());
    this.provideBillFacadeProvider = DoubleCheck.provider(BillModule_ProvideBillFacadeFactory.create());
    this.provideConfigurationProvider = DoubleCheck.provider(BillModule_ProvideConfigurationFactory.create());
    this.appEventBusProvider = DoubleCheck.provider(AppEventBus_Factory.create(provideContactFacadeProvider, provideProductBillingProvider, provideSearchFacadeProvider, provideBillFacadeProvider, provideConfigurationProvider));
    this.providePlaceControllerProvider = DoubleCheck.provider(BillModule_ProvidePlaceControllerFactory.create((Provider) appEventBusProvider));
    this.providePlaceHistoryHandlerProvider = DoubleCheck.provider(BillModule_ProvidePlaceHistoryHandlerFactory.create(BillModule_ProvidePlaceHistoryMapperFactory.create(), BillModule_ProvideHistorianFactory.create(), providePlaceControllerProvider, (Provider) appEventBusProvider));
    this.provideBillsBreadcrumbProvider = DoubleCheck.provider(BillModule_ProvideBillsBreadcrumbFactory.create(providePlaceControllerProvider));
    this.billsViewProvider = BillsView_Factory.create(provideBillsBreadcrumbProvider);
    this.provideBillsViewProvider = DoubleCheck.provider((Provider) billsViewProvider);
    this.billsPresenterProvider = BillsPresenter_Factory.create(provideBillsViewProvider, providePlaceControllerProvider);
    this.provideEditBillBreadcrumbProvider = DoubleCheck.provider(BillModule_ProvideEditBillBreadcrumbFactory.create(providePlaceControllerProvider));
    this.provideAddressLookupListenerProvider = DoubleCheck.provider(BillModule_ProvideAddressLookupListenerFactory.create(provideConfigurationProvider));
    this.editBillViewProvider = EditBillView_Factory.create(provideEditBillBreadcrumbProvider, providePlaceControllerProvider, provideAddressLookupListenerProvider);
    this.provideEditBillViewProvider = DoubleCheck.provider((Provider) editBillViewProvider);
    this.editBillPresenterProvider = EditBillPresenter_Factory.create(provideEditBillViewProvider, providePlaceControllerProvider);
    this.billControllerProvider = BillController_Factory.create(billsPresenterProvider, editBillPresenterProvider);
    this.provideActivityMapperProvider = DoubleCheck.provider((Provider) billControllerProvider);
    this.provideActivityManagerProvider = DoubleCheck.provider(BillModule_ProvideActivityManagerFactory.create(provideActivityMapperProvider, (Provider) appEventBusProvider));
  }

  @Override
  public AppEventBus getEventBus() {
    return appEventBusProvider.get();}

  @Override
  public PlaceHistoryHandler placeHistoryHandler() {
    return providePlaceHistoryHandlerProvider.get();}

  @Override
  public ActivityManager getActivityManager() {
    return provideActivityManagerProvider.get();}

  public static final class Builder {
    private Builder() {
    }

    public BillComponent build() {
      return new DaggerBillComponent();
    }
  }
}
