package biz.turnonline.ecosystem.widget.contact;

import biz.turnonline.ecosystem.widget.contact.presenter.ContactsPresenter;
import biz.turnonline.ecosystem.widget.contact.presenter.ContactsPresenter_Factory;
import biz.turnonline.ecosystem.widget.contact.presenter.EditContactPresenter;
import biz.turnonline.ecosystem.widget.contact.presenter.EditContactPresenter_Factory;
import biz.turnonline.ecosystem.widget.contact.view.ContactsView;
import biz.turnonline.ecosystem.widget.contact.view.ContactsView_Factory;
import biz.turnonline.ecosystem.widget.contact.view.EditContactView;
import biz.turnonline.ecosystem.widget.contact.view.EditContactView_Factory;
import biz.turnonline.ecosystem.widget.shared.AddressLookupListener;
import biz.turnonline.ecosystem.widget.shared.AppEventBus;
import biz.turnonline.ecosystem.widget.shared.AppEventBus_Factory;
import biz.turnonline.ecosystem.widget.shared.Configuration;
import biz.turnonline.ecosystem.widget.shared.rest.account.AccountStewardFacade;
import biz.turnonline.ecosystem.widget.shared.rest.bill.BillFacade;
import biz.turnonline.ecosystem.widget.shared.rest.billing.ProductBillingFacade;
import biz.turnonline.ecosystem.widget.shared.rest.payment.PaymentProcessorFacade;
import biz.turnonline.ecosystem.widget.shared.rest.search.SearchFacade;
import biz.turnonline.ecosystem.widget.shared.ui.ScaffoldBreadcrumb;
import com.google.gwt.activity.shared.ActivityManager;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import dagger.internal.DoubleCheck;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerContactComponent implements ContactComponent {
  private Provider<AccountStewardFacade> provideContactFacadeProvider;

  private Provider<ProductBillingFacade> provideProductBillingProvider;

  private Provider<SearchFacade> provideSearchFacadeProvider;

  private Provider<BillFacade> provideBillFacadeProvider;

  private Provider<PaymentProcessorFacade> providePaymentProcessorProvider;

  private Provider<Configuration> provideConfigurationProvider;

  private Provider<AppEventBus> appEventBusProvider;

  private Provider<PlaceController> providePlaceControllerProvider;

  private Provider<PlaceHistoryHandler> providePlaceHistoryHandlerProvider;

  private Provider<ScaffoldBreadcrumb> provideContactsBreadcrumbProvider;

  private Provider<ContactsView> contactsViewProvider;

  private Provider<ContactsPresenter.IView> provideContactsViewProvider;

  private Provider<ContactsPresenter> contactsPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideEditContactBreadcrumbProvider;

  private Provider<AddressLookupListener> provideAddressLookupListenerProvider;

  private Provider<EditContactView> editContactViewProvider;

  private Provider<EditContactPresenter.IView> provideEditContactViewProvider;

  private Provider<EditContactPresenter> editContactPresenterProvider;

  private Provider<ContactController> contactControllerProvider;

  private Provider<ActivityMapper> provideActivityMapperProvider;

  private Provider<ActivityManager> provideActivityManagerProvider;

  private DaggerContactComponent() {

    initialize();
  }

  public static Builder builder() {
    return new Builder();
  }

  public static ContactComponent create() {
    return new Builder().build();
  }

  @SuppressWarnings("unchecked")
  private void initialize() {
    this.provideContactFacadeProvider = DoubleCheck.provider(ContactModule_ProvideContactFacadeFactory.create());
    this.provideProductBillingProvider = DoubleCheck.provider(ContactModule_ProvideProductBillingFactory.create());
    this.provideSearchFacadeProvider = DoubleCheck.provider(ContactModule_ProvideSearchFacadeFactory.create());
    this.provideBillFacadeProvider = DoubleCheck.provider(ContactModule_ProvideBillFacadeFactory.create());
    this.providePaymentProcessorProvider = DoubleCheck.provider(ContactModule_ProvidePaymentProcessorFactory.create());
    this.provideConfigurationProvider = DoubleCheck.provider(ContactModule_ProvideConfigurationFactory.create());
    this.appEventBusProvider = DoubleCheck.provider(AppEventBus_Factory.create(provideContactFacadeProvider, provideProductBillingProvider, provideSearchFacadeProvider, provideBillFacadeProvider, providePaymentProcessorProvider, provideConfigurationProvider));
    this.providePlaceControllerProvider = DoubleCheck.provider(ContactModule_ProvidePlaceControllerFactory.create((Provider) appEventBusProvider));
    this.providePlaceHistoryHandlerProvider = DoubleCheck.provider(ContactModule_ProvidePlaceHistoryHandlerFactory.create(ContactModule_ProvidePlaceHistoryMapperFactory.create(), ContactModule_ProvideHistorianFactory.create(), providePlaceControllerProvider, (Provider) appEventBusProvider));
    this.provideContactsBreadcrumbProvider = DoubleCheck.provider(ContactModule_ProvideContactsBreadcrumbFactory.create(providePlaceControllerProvider));
    this.contactsViewProvider = ContactsView_Factory.create(provideContactsBreadcrumbProvider);
    this.provideContactsViewProvider = DoubleCheck.provider((Provider) contactsViewProvider);
    this.contactsPresenterProvider = ContactsPresenter_Factory.create(provideContactsViewProvider, providePlaceControllerProvider);
    this.provideEditContactBreadcrumbProvider = DoubleCheck.provider(ContactModule_ProvideEditContactBreadcrumbFactory.create(providePlaceControllerProvider));
    this.provideAddressLookupListenerProvider = DoubleCheck.provider(ContactModule_ProvideAddressLookupListenerFactory.create(provideConfigurationProvider));
    this.editContactViewProvider = EditContactView_Factory.create(provideEditContactBreadcrumbProvider, provideAddressLookupListenerProvider);
    this.provideEditContactViewProvider = DoubleCheck.provider((Provider) editContactViewProvider);
    this.editContactPresenterProvider = EditContactPresenter_Factory.create(provideEditContactViewProvider, providePlaceControllerProvider);
    this.contactControllerProvider = ContactController_Factory.create(contactsPresenterProvider, editContactPresenterProvider);
    this.provideActivityMapperProvider = DoubleCheck.provider((Provider) contactControllerProvider);
    this.provideActivityManagerProvider = DoubleCheck.provider(ContactModule_ProvideActivityManagerFactory.create(provideActivityMapperProvider, (Provider) appEventBusProvider));
  }

  @Override
  public AppEventBus getEventBus() {
    return appEventBusProvider.get();
  }

  @Override
  public PlaceHistoryHandler placeHistoryHandler() {
    return providePlaceHistoryHandlerProvider.get();
  }

  @Override
  public ActivityManager getActivityManager() {
    return provideActivityManagerProvider.get();
  }

  public static final class Builder {
    private Builder() {
    }

    public ContactComponent build() {
      return new DaggerContactComponent();
    }
  }
}
