/*
 * Copyright (c) 2019 Comvai, s.r.o. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-12-26 at 05:51:20 UTC
 * Modify at your own risk.
 */

package biz.turnonline.ecosystem.widget.shared.rest.billing;

import java.util.Date;
import java.util.List;

/**
 * Model definition for PurchaseOrder.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the TurnOnline.biz Product Billing. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
public final class PurchaseOrder
{
    /**
     * The value may be {@code null}.
     */
    private Date beginOn;

    /**
     * The value may be {@code null}.
     */
    private Date createdDate;

    /**
     * The value may be {@code null}.
     */
    private Creditor creditor;

    /**
     * The value may be {@code null}.
     */
    private String currency;

    /**
     * The value may be {@code null}.
     */
    private Customer customer;

    /**
     * The value may be {@code null}.
     */
    private Long id;

    /**
     * The value may be {@code null}.
     */
    private String invoiceType;

    /**
     * The value may be {@code null}.
     */
    private List<IncomingInvoice> invoices;

    /**
     * The value may be {@code null}.
     */
    private List<PricingItem> items;

    /**
     * The value may be {@code null}.
     */
    private Date lastBillingDate;

    /**
     * The value may be {@code null}.
     */
    private Date modificationDate;

    /**
     * The value may be {@code null}.
     */
    private Date nextBillingDate;

    /**
     * The value may be {@code null}.
     */
    private Integer numberOfDays;

    /**
     * The value may be {@code null}.
     */
    private String periodicity;

    /**
     * The value may be {@code null}.
     */
    private String status;

    /**
     * The value may be {@code null}.
     */
    private Double totalPrice;

    /**
     * The value may be {@code null}.
     */
    private Double totalPriceExclVat;

    /**
     * The value may be {@code null}.
     */
    private Double totalVatBase;

    /**
     * @return value or {@code null} for none
     */
    public Date getBeginOn()
    {
        return beginOn;
    }

    /**
     * @param beginOn beginOn or {@code null} for none
     */
    public PurchaseOrder setBeginOn( Date beginOn )
    {
        this.beginOn = beginOn;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Date getCreatedDate()
    {
        return createdDate;
    }

    /**
     * @param createdDate createdDate or {@code null} for none
     */
    public PurchaseOrder setCreatedDate( Date createdDate )
    {
        this.createdDate = createdDate;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Creditor getCreditor()
    {
        return creditor;
    }

    /**
     * @param creditor creditor or {@code null} for none
     */
    public PurchaseOrder setCreditor( Creditor creditor )
    {
        this.creditor = creditor;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getCurrency()
    {
        return currency;
    }

    /**
     * @param currency currency or {@code null} for none
     */
    public PurchaseOrder setCurrency( String currency )
    {
        this.currency = currency;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Customer getCustomer()
    {
        return customer;
    }

    /**
     * @param customer customer or {@code null} for none
     */
    public PurchaseOrder setCustomer( Customer customer )
    {
        this.customer = customer;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Long getId()
    {
        return id;
    }

    /**
     * @param id id or {@code null} for none
     */
    public PurchaseOrder setId( Long id )
    {
        this.id = id;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getInvoiceType()
    {
        return invoiceType;
    }

    /**
     * @param invoiceType invoiceType or {@code null} for none
     */
    public PurchaseOrder setInvoiceType( String invoiceType )
    {
        this.invoiceType = invoiceType;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public List<IncomingInvoice> getInvoices()
    {
        return invoices;
    }

    /**
     * @param invoices invoices or {@code null} for none
     */
    public PurchaseOrder setInvoices( List<IncomingInvoice> invoices )
    {
        this.invoices = invoices;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public List<PricingItem> getItems()
    {
        return items;
    }

    /**
     * @param items items or {@code null} for none
     */
    public PurchaseOrder setItems( List<PricingItem> items )
    {
        this.items = items;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Date getLastBillingDate()
    {
        return lastBillingDate;
    }

    /**
     * @param lastBillingDate lastBillingDate or {@code null} for none
     */
    public PurchaseOrder setLastBillingDate( Date lastBillingDate )
    {
        this.lastBillingDate = lastBillingDate;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Date getModificationDate()
    {
        return modificationDate;
    }

    /**
     * @param modificationDate modificationDate or {@code null} for none
     */
    public PurchaseOrder setModificationDate( Date modificationDate )
    {
        this.modificationDate = modificationDate;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Date getNextBillingDate()
    {
        return nextBillingDate;
    }

    /**
     * @param nextBillingDate nextBillingDate or {@code null} for none
     */
    public PurchaseOrder setNextBillingDate( Date nextBillingDate )
    {
        this.nextBillingDate = nextBillingDate;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Integer getNumberOfDays()
    {
        return numberOfDays;
    }

    /**
     * @param numberOfDays numberOfDays or {@code null} for none
     */
    public PurchaseOrder setNumberOfDays( Integer numberOfDays )
    {
        this.numberOfDays = numberOfDays;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getPeriodicity()
    {
        return periodicity;
    }

    /**
     * @param periodicity periodicity or {@code null} for none
     */
    public PurchaseOrder setPeriodicity( String periodicity )
    {
        this.periodicity = periodicity;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getStatus()
    {
        return status;
    }

    /**
     * @param status status or {@code null} for none
     */
    public PurchaseOrder setStatus( String status )
    {
        this.status = status;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Double getTotalPrice()
    {
        return totalPrice;
    }

    /**
     * @param totalPrice totalPrice or {@code null} for none
     */
    public PurchaseOrder setTotalPrice( Double totalPrice )
    {
        this.totalPrice = totalPrice;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Double getTotalPriceExclVat()
    {
        return totalPriceExclVat;
    }

    /**
     * @param totalPriceExclVat totalPriceExclVat or {@code null} for none
     */
    public PurchaseOrder setTotalPriceExclVat( Double totalPriceExclVat )
    {
        this.totalPriceExclVat = totalPriceExclVat;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Double getTotalVatBase()
    {
        return totalVatBase;
    }

    /**
     * @param totalVatBase totalVatBase or {@code null} for none
     */
    public PurchaseOrder setTotalVatBase( Double totalVatBase )
    {
        this.totalVatBase = totalVatBase;
        return this;
    }

    /**
     * Returns the formatted name of the purchase order, a message for end user.
     * The composition of the creditor business name and the purchase order ID.
     *
     * @return the purchase order formatted name
     */
    public String formattedName()
    {
        StringBuilder builder = new StringBuilder();

        if ( creditor != null && creditor.getBusinessName() != null )
        {
            builder.append( creditor.getBusinessName() );
        }

        if ( id != null )
        {
            if ( builder.length() == 0 )
            {
                builder.append( id );
            }
            else
            {
                builder.append( " (" );
                builder.append( id );
                builder.append( ")" );
            }
        }

        return builder.toString();
    }
}
