/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-07-31 at 14:32:05 UTC
 * Modify at your own risk.
 */

package biz.turnonline.ecosystem.widget.shared.rest.billing;

import biz.turnonline.ecosystem.widget.shared.rest.RelevantNullChecker;

import java.util.List;
import java.util.Map;

/**
 * Model definition for ProductPricing.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the TurnOnline.biz Product Billing. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings( "javadoc" )
public final class ProductPricing
        implements RelevantNullChecker
{
    /**
     * The value may be {@code null}.
     */
    private String currency;

    /**
     * The value may be {@code null}.
     */
    private List<ProductDiscount> discounts;

    /**
     * The value may be {@code null}.
     */
    private Boolean domesticDelivery;

    /**
     * The value may be {@code null}.
     */
    private PricingItem items;

    /**
     * The value may be {@code null}.
     */

    private Double priceExclVat;

    /**
     * The value may be {@code null}.
     */
    private Map<String, Object> subsidiary;

    /**
     * The value may be {@code null}.
     */
    private List<PricingStructureTemplate> template;

    /**
     * The value may be {@code null}.
     */
    private String vat;

    /**
     * The value may be {@code null}.
     */
    private String vatEU;

    /**
     * The value may be {@code null}.
     */
    private String vatNonEU;

    /**
     * @return value or {@code null} for none
     */
    public String getCurrency()
    {
        return currency;
    }

    /**
     * @param currency currency or {@code null} for none
     */
    public ProductPricing setCurrency( String currency )
    {
        this.currency = currency;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public List<ProductDiscount> getDiscounts()
    {
        return discounts;
    }

    /**
     * @param discounts discounts or {@code null} for none
     */
    public ProductPricing setDiscounts( List<ProductDiscount> discounts )
    {
        this.discounts = discounts;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Boolean getDomesticDelivery()
    {
        return domesticDelivery;
    }

    /**
     * @param domesticDelivery domesticDelivery or {@code null} for none
     */
    public ProductPricing setDomesticDelivery( Boolean domesticDelivery )
    {
        this.domesticDelivery = domesticDelivery;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public PricingItem getItems()
    {
        return items;
    }

    /**
     * @param items items or {@code null} for none
     */
    public ProductPricing setItems( PricingItem items )
    {
        this.items = items;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Double getPriceExclVat()
    {
        return priceExclVat;
    }

    /**
     * @param priceExclVat priceExclVat or {@code null} for none
     */
    public ProductPricing setPriceExclVat( Double priceExclVat )
    {
        this.priceExclVat = priceExclVat;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Map<String, Object> getSubsidiary()
    {
        return subsidiary;
    }

    /**
     * @param subsidiary subsidiary or {@code null} for none
     */
    public ProductPricing setSubsidiary( Map<String, Object> subsidiary )
    {
        this.subsidiary = subsidiary;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public List<PricingStructureTemplate> getTemplate()
    {
        return template;
    }

    /**
     * @param template template or {@code null} for none
     */
    public ProductPricing setTemplate( List<PricingStructureTemplate> template )
    {
        this.template = template;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getVat()
    {
        return vat;
    }

    /**
     * @param vat vat or {@code null} for none
     */
    public ProductPricing setVat( String vat )
    {
        this.vat = vat;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getVatEU()
    {
        return vatEU;
    }

    /**
     * @param vatEU vatEU or {@code null} for none
     */
    public ProductPricing setVatEU( String vatEU )
    {
        this.vatEU = vatEU;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getVatNonEU()
    {
        return vatNonEU;
    }

    /**
     * @param vatNonEU vatNonEU or {@code null} for none
     */
    public ProductPricing setVatNonEU( String vatNonEU )
    {
        this.vatNonEU = vatNonEU;
        return this;
    }

    @Override
    public boolean allNull()
    {
        // there will be always at least a default values
        return false;
    }
}
