/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-07-31 at 14:32:05 UTC
 * Modify at your own risk.
 */

package biz.turnonline.ecosystem.widget.shared.rest.billing;

import java.util.Objects;

/**
 * Model definition for ProductPicture.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the TurnOnline.biz Product Billing. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings( "javadoc" )
public final class ProductPicture
{

    /**
     * The value may be {@code null}.
     */
    private Integer order;

    /**
     * The value may be {@code null}.
     */
    private String servingUrl;

    /**
     * The value may be {@code null}.
     */
    private String storageName;

    /**
     * @return value or {@code null} for none
     */
    public Integer getOrder()
    {
        return order;
    }

    /**
     * @param order order or {@code null} for none
     */
    public ProductPicture setOrder( Integer order )
    {
        this.order = order;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getServingUrl()
    {
        return servingUrl;
    }

    /**
     * @param servingUrl servingUrl or {@code null} for none
     */
    public ProductPicture setServingUrl( String servingUrl )
    {
        this.servingUrl = servingUrl;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getStorageName()
    {
        return storageName;
    }

    /**
     * @param storageName storageName or {@code null} for none
     */
    public ProductPicture setStorageName( String storageName )
    {
        this.storageName = storageName;
        return this;
    }

    @Override
    public boolean equals( Object o )
    {
        if ( this == o ) return true;
        if ( !( o instanceof ProductPicture ) ) return false;
        ProductPicture that = ( ProductPicture ) o;
        return storageName.equals( that.storageName );
    }

    @Override
    public int hashCode()
    {
        return Objects.hash( storageName );
    }
}
