/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-07-31 at 14:32:05 UTC
 * Modify at your own risk.
 */

package biz.turnonline.ecosystem.widget.shared.rest.billing;

import biz.turnonline.ecosystem.widget.shared.rest.RelevantNullChecker;

/**
 * Model definition for ProductInvoicing.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the TurnOnline.biz Product Billing. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings( "javadoc" )
public final class ProductInvoicing
        implements RelevantNullChecker
{
    /**
     * The value may be {@code null}.
     */
    private String code;

    /**
     * The value may be {@code null}.
     */
    private NumberSeries numberSeries;

    /**
     * The value may be {@code null}.
     */
    private Integer trialPeriod;

    /**
     * The value may be {@code null}.
     */
    private String unit;

    /**
     * @return value or {@code null} for none
     */
    public String getCode()
    {
        return code;
    }

    /**
     * @param code code or {@code null} for none
     */
    public ProductInvoicing setCode( String code )
    {
        this.code = code;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public NumberSeries getNumberSeries()
    {
        return numberSeries;
    }

    /**
     * @param numberSeries numberSeries or {@code null} for none
     */
    public ProductInvoicing setNumberSeries( NumberSeries numberSeries )
    {
        this.numberSeries = numberSeries;
        return this;
    }

    public void setNumberSeriesIf( NumberSeries numberSeries )
    {
        setIfNotAllNull( this::setNumberSeries, numberSeries );
    }

    /**
     * @return value or {@code null} for none
     */
    public Integer getTrialPeriod()
    {
        return trialPeriod;
    }

    /**
     * @param trialPeriod trialPeriod or {@code null} for none
     */
    public ProductInvoicing setTrialPeriod( Integer trialPeriod )
    {
        this.trialPeriod = trialPeriod;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getUnit()
    {
        return unit;
    }

    /**
     * @param unit unit or {@code null} for none
     */
    public ProductInvoicing setUnit( String unit )
    {
        this.unit = unit;
        return this;
    }

    @Override
    public boolean allNull()
    {
        return allNull( code, numberSeries, trialPeriod, unit );
    }
}
