/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-07-31 at 14:32:05 UTC
 * Modify at your own risk.
 */

package biz.turnonline.ecosystem.widget.shared.rest.billing;

import biz.turnonline.ecosystem.widget.shared.rest.RelevantNullChecker;

import java.util.Date;
import java.util.List;

/**
 * Model definition for InvoicePayment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the TurnOnline.biz Product Billing. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
public final class InvoicePayment
        implements RelevantNullChecker
{
    /**
     * The value may be {@code null}.
     */
    private BankAccount bankAccount;

    /**
     * The value may be {@code null}.
     */
    private Date dueDate;

    /**
     * The value may be {@code null}.
     */
    private String key;

    /**
     * The value may be {@code null}.
     */
    private String method;

    /**
     * The value may be {@code null}.
     */
    private Double totalAmount;

    /**
     * The value may be {@code null}.
     */
    private List<Transaction> transactions;

    /**
     * The value may be {@code null}.
     */
    private Long variableSymbol;

    /**
     * @return value or {@code null} for none
     */
    public BankAccount getBankAccount()
    {
        return bankAccount;
    }

    /**
     * @param bankAccount bankAccount or {@code null} for none
     */
    public InvoicePayment setBankAccount( BankAccount bankAccount )
    {
        this.bankAccount = bankAccount;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Date getDueDate()
    {
        return dueDate;
    }

    /**
     * @param dueDate dueDate or {@code null} for none
     */
    public InvoicePayment setDueDate( Date dueDate )
    {
        this.dueDate = dueDate;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getKey()
    {
        return key;
    }

    /**
     * @param key key or {@code null} for none
     */
    public InvoicePayment setKey( String key )
    {
        this.key = key;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getMethod()
    {
        return method;
    }

    /**
     * @param method method or {@code null} for none
     */
    public InvoicePayment setMethod( String method )
    {
        this.method = method;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Double getTotalAmount()
    {
        return totalAmount;
    }

    /**
     * @param totalAmount totalAmount or {@code null} for none
     */
    public InvoicePayment setTotalAmount( Double totalAmount )
    {
        this.totalAmount = totalAmount;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public List<Transaction> getTransactions()
    {
        return transactions;
    }

    /**
     * @param transactions transactions or {@code null} for none
     */
    public InvoicePayment setTransactions( List<Transaction> transactions )
    {
        this.transactions = transactions;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Long getVariableSymbol()
    {
        return variableSymbol;
    }

    /**
     * @param variableSymbol variableSymbol or {@code null} for none
     */
    public InvoicePayment setVariableSymbol( Long variableSymbol )
    {
        this.variableSymbol = variableSymbol;
        return this;
    }

    @Override
    public boolean allNull()
    {
        return allNull( bankAccount, dueDate, key, method );
    }
}
