/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-07-31 at 14:32:05 UTC
 * Modify at your own risk.
 */

package biz.turnonline.ecosystem.widget.shared.rest.billing;

import biz.turnonline.ecosystem.widget.shared.rest.RelevantNullChecker;

/**
 * Model definition for EventLocation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the TurnOnline.biz Product Billing. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings( "javadoc" )
public final class EventLocation
        implements RelevantNullChecker
{
    /**
     * The value may be {@code null}.
     */
    private String city;

    /**
     * The value may be {@code null}.
     */
    private String country;

    /**
     * The value may be {@code null}.
     */
    private String infoEmail;

    /**
     * The value may be {@code null}.
     */
    private String infoPhone;

    /**
     * The value may be {@code null}.
     */
    private Double latitude;

    /**
     * The value may be {@code null}.
     */
    private Double longitude;

    /**
     * The value may be {@code null}.
     */
    private String name;

    /**
     * The value may be {@code null}.
     */
    private String postcode;

    /**
     * The value may be {@code null}.
     */
    private String street;

    /**
     * @return value or {@code null} for none
     */
    public String getCity()
    {
        return city;
    }

    /**
     * @param city city or {@code null} for none
     */
    public EventLocation setCity( String city )
    {
        this.city = city;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getCountry()
    {
        return country;
    }

    /**
     * @param country country or {@code null} for none
     */
    public EventLocation setCountry( String country )
    {
        this.country = country;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getInfoEmail()
    {
        return infoEmail;
    }

    /**
     * @param infoEmail infoEmail or {@code null} for none
     */
    public EventLocation setInfoEmail( String infoEmail )
    {
        this.infoEmail = infoEmail;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getInfoPhone()
    {
        return infoPhone;
    }

    /**
     * @param infoPhone infoPhone or {@code null} for none
     */
    public EventLocation setInfoPhone( String infoPhone )
    {
        this.infoPhone = infoPhone;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Double getLatitude()
    {
        return latitude;
    }

    /**
     * @param latitude latitude or {@code null} for none
     */
    public EventLocation setLatitude( Double latitude )
    {
        this.latitude = latitude;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public Double getLongitude()
    {
        return longitude;
    }

    /**
     * @param longitude longitude or {@code null} for none
     */
    public EventLocation setLongitude( Double longitude )
    {
        this.longitude = longitude;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name name or {@code null} for none
     */
    public EventLocation setName( String name )
    {
        this.name = name;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getPostcode()
    {
        return postcode;
    }

    /**
     * @param postcode postcode or {@code null} for none
     */
    public EventLocation setPostcode( String postcode )
    {
        this.postcode = postcode;
        return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public String getStreet()
    {
        return street;
    }

    /**
     * @param street street or {@code null} for none
     */
    public EventLocation setStreet( String street )
    {
        this.street = street;
        return this;
    }

    @Override
    public boolean allNull()
    {
        // country is excluded from the check.
        // If only country property has set (default) it means no user input so ignore.
        return allNull( city, infoEmail, infoPhone, name, postcode, street );
    }
}
