/*
 * Billing Processor
 * No description
 *
 * OpenAPI spec version: 1.0.0
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package biz.turnonline.ecosystem.widget.shared.rest.bill;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Bill
 */
public class Bill
{
    @JsonProperty( "billNumber" )
    private String billNumber = null;

    @JsonProperty( "createdDate" )
    private Date createdDate = null;

    @JsonProperty( "dateOfIssue" )
    private Date dateOfIssue = null;

    @JsonProperty( "id" )
    private Long id = null;

    @JsonProperty( "itemName" )
    private String itemName = null;

    @JsonProperty( "items" )
    private List<BillItem> items = null;

    @JsonProperty( "modificationDate" )
    private Date modificationDate = null;

    @JsonProperty( "supplier" )
    private Supplier supplier = null;

    @JsonProperty( "totalPrice" )
    private Double totalPrice = null;

    @JsonProperty( "currency" )
    private String currency = null;

    @JsonProperty( "type" )
    private TypeEnum type = null;

    @JsonProperty( "servingUrl" )
    private String servingUrl;

    @JsonProperty( "storageName" )
    private String storageName;

    public Bill billNumber( String billNumber )
    {
        this.billNumber = billNumber;
        return this;
    }

    /**
     * Bill order number, or in case of incoming invoice an invoice number
     *
     * @return billNumber
     **/
    @JsonProperty( "billNumber" )
    public String getBillNumber()
    {
        return billNumber;
    }

    public void setBillNumber( String billNumber )
    {
        this.billNumber = billNumber;
    }

    public Bill createdDate( Date createdDate )
    {
        this.createdDate = createdDate;
        return this;
    }

    /**
     * A date when bill record has been created. Managed solely by the service. RFC 3339
     *
     * @return createdDate
     **/
    @JsonProperty( "createdDate" )
    public Date getCreatedDate()
    {
        return createdDate;
    }

    public void setCreatedDate( Date createdDate )
    {
        this.createdDate = createdDate;
    }

    public Bill dateOfIssue( Date dateOfIssue )
    {
        this.dateOfIssue = dateOfIssue;
        return this;
    }

    /**
     * The date when the cash register document has been issued. If not provided, the current date will be used. RFC 3339
     *
     * @return dateOfIssue
     **/
    @JsonProperty( "dateOfIssue" )
    public Date getDateOfIssue()
    {
        return dateOfIssue;
    }

    public void setDateOfIssue( Date dateOfIssue )
    {
        this.dateOfIssue = dateOfIssue;
    }

    public Bill id( Long id )
    {
        this.id = id;
        return this;
    }

    /**
     * The unique bill identification.
     *
     * @return id
     **/
    @JsonProperty( "id" )
    public Long getId()
    {
        return id;
    }

    public void setId( Long id )
    {
        this.id = id;
    }

    public Bill itemName( String itemName )
    {
        this.itemName = itemName;
        return this;
    }

    /**
     * Bill name
     *
     * @return itemName
     **/
    @JsonProperty( "itemName" )
    public String getItemName()
    {
        return itemName;
    }

    public void setItemName( String itemName )
    {
        this.itemName = itemName;
    }

    public Bill items( List<BillItem> items )
    {
        this.items = items;
        return this;
    }

    public Bill addItemsItem( BillItem itemsItem )
    {
        if ( this.items == null )
        {
            this.items = new ArrayList<>();
        }
        this.items.add( itemsItem );
        return this;
    }

    /**
     * Get items
     *
     * @return items
     **/
    @JsonProperty( "items" )
    public List<BillItem> getItems()
    {
        return items;
    }

    public void setItems( List<BillItem> items )
    {
        this.items = items;
    }

    public Bill modificationDate( Date modificationDate )
    {
        this.modificationDate = modificationDate;
        return this;
    }

    /**
     * The date of the last modification of the bill resource values. Managed solely by the service. RFC 3339
     *
     * @return modificationDate
     **/
    @JsonProperty( "modificationDate" )
    public Date getModificationDate()
    {
        return modificationDate;
    }

    public void setModificationDate( Date modificationDate )
    {
        this.modificationDate = modificationDate;
    }

    public Bill supplier( Supplier supplier )
    {
        this.supplier = supplier;
        return this;
    }

    /**
     * Get supplier
     *
     * @return supplier
     **/
    @JsonProperty( "supplier" )
    public Supplier getSupplier()
    {
        return supplier;
    }

    public void setSupplier( Supplier supplier )
    {
        this.supplier = supplier;
    }

    public Bill totalPrice( Double totalPrice )
    {
        this.totalPrice = totalPrice;
        return this;
    }

    /**
     * The order total price as a sum of all checked in order items and its amount including target rounding mode. Including VAT.
     *
     * @return totalPrice
     **/
    @JsonProperty( "totalPrice" )
    public Double getTotalPrice()
    {
        return totalPrice;
    }

    public void setTotalPrice( Double totalPrice )
    {
        this.totalPrice = totalPrice;
    }

    /**
     * The bill currency
     *
     * @return currency
     **/
    @JsonProperty( "currency" )
    public String getCurrency()
    {
        return currency;
    }

    public void setCurrency( String currency )
    {
        this.currency = currency;
    }

    public Bill type( TypeEnum type )
    {
        this.type = type;
        return this;
    }

    /**
     * Type of document
     *
     * @return type
     **/
    @JsonProperty( "type" )
    public TypeEnum getType()
    {
        return type;
    }

    public void setType( TypeEnum type )
    {
        this.type = type;
    }

    /**
     * Serving url of bill scan
     *
     * @return type
     **/
    @JsonProperty( "servingUrl" )
    public String getServingUrl()
    {
        return servingUrl;
    }

    public void setServingUrl( String servingUrl )
    {
        this.servingUrl = servingUrl;
    }

    /**
     * Storage name of bill scan
     *
     * @return type
     **/
    @JsonProperty( "storageName" )
    public String getStorageName()
    {
        return storageName;
    }

    public void setStorageName( String storageName )
    {
        this.storageName = storageName;
    }

    @Override
    public String toString()
    {
        return "class Bill {\n" +
                "    billNumber: " + toIndentedString( billNumber ) + "\n" +
                "    createdDate: " + toIndentedString( createdDate ) + "\n" +
                "    dateOfIssue: " + toIndentedString( dateOfIssue ) + "\n" +
                "    id: " + toIndentedString( id ) + "\n" +
                "    itemName: " + toIndentedString( itemName ) + "\n" +
                "    items: " + toIndentedString( items ) + "\n" +
                "    modificationDate: " + toIndentedString( modificationDate ) + "\n" +
                "    supplier: " + toIndentedString( supplier ) + "\n" +
                "    totalPrice: " + toIndentedString( totalPrice ) + "\n" +
                "    type: " + toIndentedString( type ) + "\n" +
                "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString( Object o )
    {
        if ( o == null )
        {
            return "null";
        }
        return o.toString().replace( "\n", "\n    " );
    }

    /**
     * Type of document
     */
    public enum TypeEnum
    {
        CASH_REGISTER_DOCUMENT( "CASH_REGISTER_DOCUMENT" ),

        INCOMING_INVOICE( "INCOMING_INVOICE" );

        private String value;

        TypeEnum( String value )
        {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromValue( String text )
        {
            for ( TypeEnum b : TypeEnum.values() )
            {
                if ( String.valueOf( b.value ).equals( text ) )
                {
                    return b;
                }
            }
            return null;
        }

        @Override
        @JsonValue
        public String toString()
        {
            return String.valueOf( value );
        }
    }
}

