/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.aem.applyenvvarsinstallhook;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHook;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyEnvVarsInstallHook
implements InstallHook {
    private static final Logger LOG = LoggerFactory.getLogger(ApplyEnvVarsInstallHook.class);
    private static final String PROP_APPLY_ENV_VARS_FOR_PATHS = "applyEnvVarsForPaths";
    private static final String PROP_FAIL_FOR_MISSING_ENV_VARS = "failForMissingEnvVars";
    private static final String TEMPLATE_SUFFIX = ".TEMPLATE";
    private int countVarsReplaced = 0;
    private int countVarsDefaultUsed = 0;
    private int countVarsNotFound = 0;

    public void execute(InstallContext context) throws PackageException {
        try {
            Session session = context.getSession();
            ImportOptions options = context.getOptions();
            VaultPackage vaultPackage = context.getPackage();
            WorkspaceFilter filter = vaultPackage.getMetaInf().getFilter();
            Map<String, String> env = System.getenv();
            switch (context.getPhase()) {
                case PREPARE: {
                    this.log(this.getClass().getSimpleName() + " is active in " + vaultPackage.getId(), options);
                    boolean failForMissingEnvVar = Boolean.valueOf(vaultPackage.getProperties().getProperty(PROP_FAIL_FOR_MISSING_ENV_VARS));
                    LOG.debug("Property failForMissingEnvVar from package={}", (Object)failForMissingEnvVar);
                    if (!failForMissingEnvVar) break;
                    this.log(this.getClass().getSimpleName() + " checking if all env vars are set due to package property failForMissingEnvVar=true", options);
                    Archive archive = vaultPackage.getArchive();
                    boolean allVariablesFoundInEnv = this.findMissingEnvVarInPackageEntry(archive, "/", archive.getJcrRoot(), options);
                    if (!allVariablesFoundInEnv) {
                        String errMsg = "Aborting installation of package " + vaultPackage.getId() + " due to missing env variables";
                        this.log(errMsg, options);
                        throw new PackageException(errMsg);
                    }
                    break;
                }
                case INSTALLED: {
                    ArrayList<String> jcrPathsToBeAdjusted = new ArrayList<String>();
                    String applyEnvVarsForPaths = vaultPackage.getProperties().getProperty(PROP_APPLY_ENV_VARS_FOR_PATHS);
                    LOG.debug("Property applyEnvVarsForPaths from package={}", (Object)applyEnvVarsForPaths);
                    if (StringUtils.isNotBlank((String)applyEnvVarsForPaths)) {
                        jcrPathsToBeAdjusted.addAll(Arrays.asList(applyEnvVarsForPaths.trim().split("[\\s*,]+")));
                    }
                    this.collectTemplateNodes(vaultPackage, session, jcrPathsToBeAdjusted);
                    if (jcrPathsToBeAdjusted.isEmpty()) {
                        this.log("Install Hook " + this.getClass().getName() + " was configured but package property 'applyEnvVarsForPaths' was left blank and no .TEMPLATE nodes were configured", options);
                        return;
                    }
                    for (String jcrPathToBeAdjusted : jcrPathsToBeAdjusted) {
                        if (jcrPathToBeAdjusted.contains("@")) {
                            String[] pathAndProperty = jcrPathToBeAdjusted.split("@", 2);
                            String path = pathAndProperty[0];
                            if (this.isNotCoveredbyFilter(filter, path, options)) continue;
                            String propertyName = pathAndProperty[1];
                            this.adjustProperty(session, path, propertyName, env, options);
                            continue;
                        }
                        if (this.isNotCoveredbyFilter(filter, jcrPathToBeAdjusted, options)) continue;
                        Node nodeToBeAdjusted = session.getNode(jcrPathToBeAdjusted);
                        if (this.isFile(nodeToBeAdjusted)) {
                            String fileContent = IOUtils.toString((InputStream)JcrUtils.readFile((Node)nodeToBeAdjusted));
                            String adjustedFileContent = this.applyEnvVars(fileContent, env, nodeToBeAdjusted.getPath(), options);
                            String targetNodeName = this.isTemplateNode(nodeToBeAdjusted) ? StringUtils.substringBeforeLast((String)nodeToBeAdjusted.getName(), (String)TEMPLATE_SUFFIX) : nodeToBeAdjusted.getName();
                            String mimeType = "text/plain";
                            JcrUtils.putFile((Node)nodeToBeAdjusted.getParent(), (String)targetNodeName, (String)mimeType, (InputStream)new ByteArrayInputStream(adjustedFileContent.getBytes()));
                            continue;
                        }
                        if (this.isTemplateNode(nodeToBeAdjusted)) {
                            String targetPath = StringUtils.substringBeforeLast((String)nodeToBeAdjusted.getPath(), (String)TEMPLATE_SUFFIX);
                            if (session.itemExists(targetPath)) {
                                session.removeItem(targetPath);
                            }
                            nodeToBeAdjusted = this.copy(nodeToBeAdjusted, targetPath);
                        }
                        this.adjustAllPropertiesOfNodeTree(nodeToBeAdjusted, env, options);
                    }
                    this.log("Values replaced: " + this.countVarsReplaced, options);
                    if (this.countVarsDefaultUsed > 0) {
                        this.log("Default values used: " + this.countVarsDefaultUsed, options);
                    }
                    if (this.countVarsNotFound > 0) {
                        this.log("WARN: No env variable found for var and no default given: " + this.countVarsNotFound, options);
                    }
                    session.save();
                    this.log("Saved session. ", options);
                    break;
                }
            }
        }
        catch (IOException | RepositoryException e) {
            throw new PackageException("Could not execute install hook to apply env vars: " + e, e);
        }
    }

    private Node copy(Node sourceNode, String targetPath) throws RepositoryException {
        LOG.info("Copy {} to {}", (Object)sourceNode, (Object)targetPath);
        Node targetNode = JcrUtils.getOrCreateByPath((String)targetPath, (String)sourceNode.getPrimaryNodeType().getName(), (Session)sourceNode.getSession());
        PropertyIterator propertiesIt = sourceNode.getProperties();
        while (propertiesIt.hasNext()) {
            Property sourceProp = propertiesIt.nextProperty();
            if (sourceProp.getDefinition().isProtected()) continue;
            if (sourceProp.isMultiple()) {
                targetNode.setProperty(sourceProp.getName(), sourceProp.getValues(), sourceProp.getType());
            } else {
                targetNode.setProperty(sourceProp.getName(), sourceProp.getValue(), sourceProp.getType());
            }
            LOG.debug("Copied {} / {} to {}", new Object[]{sourceProp.getName(), sourceProp.getType(), targetNode});
        }
        NodeIterator nodesIt = sourceNode.getNodes();
        while (nodesIt.hasNext()) {
            Node childNode = nodesIt.nextNode();
            this.copy(childNode, targetPath + "/" + childNode.getName());
        }
        return targetNode;
    }

    private boolean isTemplateNode(Node nodeToBeAdjusted) throws RepositoryException {
        return nodeToBeAdjusted.getPath().endsWith(TEMPLATE_SUFFIX);
    }

    private boolean isFile(Node node) throws RepositoryException {
        Node relevantNode = node;
        if (relevantNode.hasNode("jcr:content")) {
            relevantNode = node.getNode("jcr:content");
        }
        boolean isFile = relevantNode.hasProperty("jcr:data");
        return isFile;
    }

    private void adjustAllPropertiesOfNodeTree(Node node, Map<String, String> env, ImportOptions options) throws RepositoryException {
        PropertyIterator propertiesIt = node.getProperties();
        while (propertiesIt.hasNext()) {
            Property prop = propertiesIt.nextProperty();
            this.adjustProperty(node.getSession(), node.getPath(), prop.getName(), env, options);
        }
        NodeIterator nodesIt = node.getNodes();
        while (nodesIt.hasNext()) {
            Node childNode = nodesIt.nextNode();
            this.adjustAllPropertiesOfNodeTree(childNode, env, options);
        }
    }

    private void adjustProperty(Session session, String path, String propertyName, Map<String, String> env, ImportOptions options) throws RepositoryException {
        String propertyPath = path + "@" + propertyName;
        try {
            LOG.debug("Looking at path {} prop {}", (Object)path, (Object)propertyName);
            Node node = session.getNode(path);
            Property property = node.getProperty(propertyName);
            if (property.getDefinition().isProtected()) {
                return;
            }
            if (property.getType() != 1) {
                LOG.debug("Property " + propertyPath + " is not of type String", (Object)options);
                return;
            }
            if (!property.isMultiple()) {
                String stringValueRaw = property.getString();
                String adjustedValue = this.applyEnvVars(stringValueRaw, env, propertyPath, options);
                property.setValue(adjustedValue);
            } else {
                ArrayList<Value> newValues = new ArrayList<Value>();
                Value[] values = property.getValues();
                for (int i = 0; i < values.length; ++i) {
                    String stringValueRaw = values[i].getString();
                    String adjustedValue = this.applyEnvVars(stringValueRaw, env, propertyPath + "[" + i + "]", options);
                    newValues.add(session.getValueFactory().createValue(adjustedValue));
                }
                property.setValue(newValues.toArray(new Value[newValues.size()]));
            }
        }
        catch (PathNotFoundException e) {
            this.log("Path " + propertyPath + " could not be found", options);
        }
    }

    private void collectTemplateNodes(VaultPackage vaultPackage, Session session, List<String> jcrPathsToBeAdjusted) throws RepositoryException {
        WorkspaceFilter workspaceFilter = vaultPackage.getMetaInf().getFilter();
        List filterSets = workspaceFilter.getFilterSets();
        for (PathFilterSet filterSet : filterSets) {
            String filterRoot = filterSet.getRoot();
            try {
                Node node = session.getNode(filterRoot);
                this.collectTemplateNodes(workspaceFilter, node, jcrPathsToBeAdjusted);
            }
            catch (PathNotFoundException e) {
                LOG.debug("Filter root {} not found", (Object)filterRoot);
            }
        }
    }

    private void collectTemplateNodes(WorkspaceFilter workspaceFilter, Node node, List<String> jcrPathsToBeAdjusted) throws RepositoryException {
        String nodePath = node.getPath();
        LOG.debug("nodePath={}", (Object)nodePath);
        if (nodePath.endsWith(TEMPLATE_SUFFIX) && workspaceFilter.covers(nodePath)) {
            jcrPathsToBeAdjusted.add(nodePath);
            LOG.debug("found={}", (Object)nodePath);
        }
        NodeIterator nodesIt = node.getNodes();
        while (nodesIt.hasNext()) {
            Node childNode = nodesIt.nextNode();
            this.collectTemplateNodes(workspaceFilter, childNode, jcrPathsToBeAdjusted);
        }
    }

    private boolean isNotCoveredbyFilter(WorkspaceFilter filter, String path, ImportOptions options) {
        boolean covered = filter.covers(path);
        if (!covered) {
            this.log("Path " + path + " is not covered by filter \n" + filter.getSourceAsString(), options);
        }
        return !covered;
    }

    String applyEnvVars(String text, Map<String, String> env, String path, ImportOptions options) {
        Matcher matcher = EnvVarDeclaration.VAR_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String action;
            String valueToBeUsed;
            EnvVarDeclaration envVar = new EnvVarDeclaration(matcher.group(1));
            if (env.containsKey(envVar.effectiveName)) {
                valueToBeUsed = env.get(envVar.effectiveName);
                ++this.countVarsReplaced;
                action = "replaced from env";
            } else {
                String effectiveDefaultVal;
                if (envVar.defaultVal != null) {
                    effectiveDefaultVal = envVar.defaultVal;
                    ++this.countVarsDefaultUsed;
                    action = "default in package";
                } else {
                    effectiveDefaultVal = matcher.group(0);
                    ++this.countVarsNotFound;
                    action = "env var not found, no default provided!";
                }
                valueToBeUsed = effectiveDefaultVal;
            }
            this.log(path.replace(TEMPLATE_SUFFIX, "") + ": " + envVar.name + "=\"" + valueToBeUsed + "\" (" + action + ")", options);
            matcher.appendReplacement(result, Matcher.quoteReplacement(valueToBeUsed));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public void log(String message, ImportOptions options) {
        ProgressTrackerListener listener = options.getListener();
        if (listener != null) {
            listener.onMessage(ProgressTrackerListener.Mode.TEXT, message, "");
            LOG.debug(message);
        } else {
            LOG.info(message);
        }
    }

    private boolean findMissingEnvVarInPackageEntry(Archive archive, String parentPath, Archive.Entry entry, ImportOptions options) {
        String path = parentPath + "/" + entry.getName();
        boolean result = true;
        if (!entry.isDirectory()) {
            String fileContent = null;
            LOG.debug("Reading file {}", (Object)path);
            try {
                InputStream input = archive.getInputSource(entry).getByteStream();
                if (input == null) {
                    throw new IllegalStateException("Could not get input stream from entry " + path);
                }
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)input, (Writer)writer, (String)"UTF-8");
                fileContent = writer.toString();
            }
            catch (Exception e) {
                this.log("Could not read " + path + " as text, skipping (" + e + ")", options);
            }
            if (fileContent != null) {
                Map<String, String> systemEnv = System.getenv();
                Matcher matcher = EnvVarDeclaration.VAR_PATTERN.matcher(fileContent);
                while (matcher.find()) {
                    EnvVarDeclaration envVar = new EnvVarDeclaration(matcher.group(1));
                    if (envVar.defaultVal != null) {
                        LOG.debug("Default value given for variable {}", (Object)envVar);
                        continue;
                    }
                    if (systemEnv.containsKey(envVar.effectiveName)) continue;
                    this.log("Env Variable '" + envVar.effectiveName + "' is not found but ${" + envVar.name + "} is used in file " + path + " without declaring a default", options);
                    result = false;
                }
            }
        }
        Collection children = entry.getChildren();
        for (Archive.Entry subEntry : children) {
            result &= this.findMissingEnvVarInPackageEntry(archive, path, subEntry, options);
        }
        return result;
    }

    private static class EnvVarDeclaration {
        private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
        private String name;
        private String effectiveName;
        private String defaultVal;

        EnvVarDeclaration(String groupOneOfMatcher) {
            String givenVarAndDefault = groupOneOfMatcher;
            String[] bits = givenVarAndDefault.split(":", 2);
            this.name = bits[0];
            this.effectiveName = this.name.replaceAll("\\.", "_");
            this.defaultVal = bits.length > 1 ? bits[1] : null;
        }
    }
}

