/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.context.test;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.context.Resolvable;

public class ContextTestCase
extends TestCase {
    public ContextTestCase(String name) {
        super(name);
    }

    public void testAddContext() throws Exception {
        DefaultContext context = new DefaultContext();
        context.put("key1", "value1");
        Assert.assertTrue((boolean)"value1".equals(context.get("key1")));
        context.put("key1", "");
        Assert.assertTrue((boolean)"".equals(context.get("key1")));
        context.put("key1", "value1");
        context.makeReadOnly();
        try {
            context.put("key1", "");
            throw new AssertionFailedError("You are not allowed to change a value after it has been made read only");
        }
        catch (IllegalStateException ise) {
            Assert.assertTrue((String)"Value is null", (boolean)"value1".equals(context.get("key1")));
            return;
        }
    }

    public void testResolveableObject() throws ContextException {
        DefaultContext context = new DefaultContext();
        context.put("key1", new ResolvableString());
        context.put("test", "Cool Test");
        context.makeReadOnly();
        DefaultContext newContext = context;
        Assert.assertTrue((boolean)"Cool Test".equals(newContext.get("test")));
        Assert.assertTrue((!"This is a ${test}.".equals(newContext.get("key1")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"This is a Cool Test.".equals(newContext.get("key1")));
    }

    public void testCascadingContext() throws ContextException {
        DefaultContext parent = new DefaultContext();
        parent.put("test", "ok test");
        parent.makeReadOnly();
        DefaultContext child = new DefaultContext(parent);
        child.put("check", new ResolvableString("This is an ${test}."));
        child.makeReadOnly();
        DefaultContext context = child;
        Assert.assertTrue((boolean)"ok test".equals(context.get("test")));
        Assert.assertTrue((!"This is an ${test}.".equals(context.get("check")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"This is an ok test.".equals(context.get("check")));
    }

    public void testHiddenItems() throws ContextException {
        DefaultContext parent = new DefaultContext();
        parent.put("test", "test");
        parent.makeReadOnly();
        DefaultContext child = new DefaultContext(parent);
        child.put("check", "check");
        DefaultContext context = child;
        Assert.assertTrue((boolean)"check".equals(context.get("check")));
        Assert.assertTrue((boolean)"test".equals(context.get("test")));
        child.hide("test");
        try {
            context.get("test");
            Assert.fail((String)"The item \"test\" was hidden in the child context, but could still be retrieved via get().");
        }
        catch (ContextException ce) {
            // empty catch block
        }
        child.makeReadOnly();
        try {
            child.hide("test");
            Assert.fail((String)"hide() did not throw an exception, even though the context is supposed to be read-only.");
        }
        catch (IllegalStateException ise) {}
    }

    private static class ResolvableString
    implements Resolvable {
        private final String m_content;

        public ResolvableString(String content) {
            this.m_content = content;
        }

        public ResolvableString() {
            this("This is a ${test}.");
        }

        public final Object resolve(Context context) throws ContextException {
            int index = this.m_content.indexOf("${");
            if (index < 0) {
                return this.m_content;
            }
            StringBuffer buf = new StringBuffer(this.m_content.substring(0, index));
            while (index >= 0 && index <= this.m_content.length()) {
                int end = this.m_content.indexOf("}", index += 2);
                if (end < 0) {
                    end = this.m_content.length();
                }
                buf.append(context.get(this.m_content.substring(index, end)));
                index = this.m_content.indexOf("${", ++end) + 2;
                if (index < 2) {
                    index = -1;
                    buf.append(this.m_content.substring(end, this.m_content.length()));
                }
                if (index < 0 || index > this.m_content.length()) continue;
                buf.append(this.m_content.substring(end, index));
            }
            return buf.toString();
        }
    }
}

