/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public final class DefaultConfigurationTestCase
extends TestCase {
    private DefaultConfiguration m_configuration;

    public DefaultConfigurationTestCase() {
        this("DefaultConfiguration Test Case");
    }

    public DefaultConfigurationTestCase(String name) {
        super(name);
    }

    public void setUp() {
        this.m_configuration = new DefaultConfiguration("a", "b");
    }

    public void tearDowm() {
        this.m_configuration = null;
    }

    public void testGetValue() throws Exception {
        String orgValue = "Original String";
        this.m_configuration.setValue("Original String");
        Assert.assertEquals((String)"Original String", (String)this.m_configuration.getValue());
    }

    public void testGetValueAsInteger() throws Exception {
        int orgValue = 55;
        String strValue = Integer.toHexString(55);
        this.m_configuration.setValue("0x" + strValue);
        Assert.assertEquals((int)55, (int)this.m_configuration.getValueAsInteger());
    }

    public void testGetValueAsBoolen() throws Exception {
        boolean b = true;
        this.m_configuration.setValue("TrUe");
        Assert.assertEquals((boolean)true, (boolean)this.m_configuration.getValueAsBoolean());
    }

    public void testGetAttribute() throws Exception {
        String key = "key";
        String value = "original value";
        String defaultStr = "default";
        this.m_configuration.setAttribute("key", "original value");
        Assert.assertEquals((String)"original value", (String)this.m_configuration.getAttribute("key", "default"));
        Assert.assertEquals((String)"default", (String)this.m_configuration.getAttribute("newKey", "default"));
    }

    public void testMakeReadOnly() {
        String key = "key";
        String value = "original value";
        String exception = "exception not thrown";
        String exceptionStr = "Configuration is read only";
        this.m_configuration.makeReadOnly();
        try {
            this.m_configuration.setAttribute("key", "original value");
        }
        catch (IllegalStateException ise) {
            exception = "Configuration is read only";
        }
        Assert.assertEquals((String)exception, (String)"Configuration is read only");
    }

    public void testAddRemoveChild() {
        String childName = "child";
        DefaultConfiguration child = new DefaultConfiguration("child", "child location");
        this.m_configuration.addChild(child);
        Assert.assertEquals((Object)child, (Object)this.m_configuration.getChild("child"));
        this.m_configuration.removeChild(child);
        Assert.assertEquals(null, (Object)this.m_configuration.getChild("child", false));
    }
}

