/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder.tags;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.avalon.meta.info.PermissionDescriptor;
import org.apache.avalon.meta.info.SecurityDescriptor;
import org.apache.avalon.meta.info.builder.tags.AbstractTag;

public class SecurityTag
extends AbstractTag {
    public static final String KEY = "security";
    public static final String PERMISSION_KEY = "security.permission";
    public static final String CLASSNAME_PARAM = "class";
    public static final String NAME_PARAM = "name";
    public static final String ACTIONS_PARAM = "actions";

    public SecurityTag(JavaClass clazz) {
        super(clazz);
    }

    public SecurityDescriptor getSecurityDescriptor() {
        PermissionDescriptor[] permissions = this.getPermissions();
        return new SecurityDescriptor(permissions, null);
    }

    public PermissionDescriptor[] getPermissions() {
        ArrayList permissions = new ArrayList();
        DocletTag[] tags = this.getJavaClass().getTagsByName(this.getNS() + "." + PERMISSION_KEY);
        this.processTags(tags, permissions);
        JavaMethod[] methods = this.findTaggedMethods(this.getJavaClass(), this.getNS() + "." + PERMISSION_KEY);
        this.processMethods(methods, permissions);
        return permissions.toArray(new PermissionDescriptor[permissions.size()]);
    }

    private void processTags(DocletTag[] tags, ArrayList permissions) {
        for (int i = 0; i < tags.length; ++i) {
            permissions.add(this.getPermission(tags[i]));
        }
    }

    private void processMethods(JavaMethod[] methods, ArrayList permissions) {
        for (int i = 0; i < methods.length; ++i) {
            DocletTag[] tags = methods[i].getTagsByName(this.getNS() + "." + PERMISSION_KEY);
            this.processTags(tags, permissions);
        }
    }

    public PermissionDescriptor getPermission(DocletTag tag) {
        String classname = this.getNamedParameter(tag, CLASSNAME_PARAM);
        String name = this.getNamedParameter(tag, NAME_PARAM, null);
        String actionString = this.getNamedParameter(tag, ACTIONS_PARAM, null);
        String[] actions = SecurityTag.expandActions(actionString);
        return new PermissionDescriptor(classname, name, actions);
    }

    private static String[] expandActions(String arg) {
        if (null == arg) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(arg, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[0]);
    }
}

