/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder.tags;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.avalon.framework.Version;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.builder.tags.AbstractTag;

public class DependencyTag
extends AbstractTag {
    public static final String KEY = "dependency";
    public static final String KEY_PARAM = "key";
    public static final String OPTIONAL_PARAM = "optional";
    protected static final String COMPONENT_MANAGER_CLASS = "org.apache.avalon.framework.component.ComponentManager";
    protected static final String SERVICE_MANAGER_CLASS = "org.apache.avalon.framework.service.ServiceManager";
    private JavaMethod[] m_methods;

    public DependencyTag(JavaClass clazz) {
        super(clazz);
        this.setMethods();
    }

    public DependencyDescriptor[] getDependencies() {
        int n = -1;
        ArrayList<DependencyDescriptor> deps = new ArrayList<DependencyDescriptor>();
        HashSet<String> marked = new HashSet<String>(10);
        for (int j = 0; j < this.m_methods.length; ++j) {
            JavaMethod method = this.m_methods[j];
            boolean flag = method.isConstructor();
            if (flag) {
                ++n;
            }
            DocletTag[] tags = method.getTagsByName(this.getNS() + "." + KEY);
            for (int i = 0; i < tags.length; ++i) {
                DocletTag tag = tags[i];
                DependencyDescriptor dep = this.getDependency(tag, flag, n);
                String key = dep.getKey();
                if (marked.contains(key)) continue;
                deps.add(dep);
                marked.add(key);
            }
        }
        return deps.toArray(new DependencyDescriptor[deps.size()]);
    }

    private DependencyDescriptor getDependency(DocletTag tag, boolean flag, int n) {
        String value = this.getNamedParameter(tag, "type");
        String type = this.resolveType(value);
        String versionString = this.getNamedParameter(tag, "version", null);
        Version version = this.resolveVersion(versionString, value);
        String key = this.getNamedParameter(tag, KEY_PARAM, type);
        String optional = this.getNamedParameter(tag, OPTIONAL_PARAM, "false");
        boolean isOptional = "true".equals(optional.toLowerCase());
        ReferenceDescriptor ref = new ReferenceDescriptor(type, version);
        if (flag) {
            return new DependencyDescriptor(key, ref, isOptional, null, n);
        }
        return new DependencyDescriptor(key, ref, isOptional, null);
    }

    private void setMethods() {
        this.m_methods = this.getLifecycleMethods("compose", COMPONENT_MANAGER_CLASS);
        if (this.m_methods.length == 0) {
            this.m_methods = this.getLifecycleMethods("service", SERVICE_MANAGER_CLASS);
            if (this.m_methods.length == 0) {
                this.m_methods = this.findConstructorMethods(this.getJavaClass(), this.getNS() + "." + KEY);
            }
        }
    }
}

