/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder.tags;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.Properties;
import org.apache.avalon.framework.Version;
import org.apache.avalon.meta.info.CategoryDescriptor;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ExtensionDescriptor;
import org.apache.avalon.meta.info.InfoDescriptor;
import org.apache.avalon.meta.info.SecurityDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.info.builder.tags.AbstractTag;
import org.apache.avalon.meta.info.builder.tags.AttributeTag;
import org.apache.avalon.meta.info.builder.tags.ContextTag;
import org.apache.avalon.meta.info.builder.tags.DependencyTag;
import org.apache.avalon.meta.info.builder.tags.ExtensionTag;
import org.apache.avalon.meta.info.builder.tags.LoggerTag;
import org.apache.avalon.meta.info.builder.tags.SchemaTag;
import org.apache.avalon.meta.info.builder.tags.SecurityTag;
import org.apache.avalon.meta.info.builder.tags.ServicesTag;
import org.apache.avalon.meta.info.builder.tags.StageTag;

public class TypeTag
extends AbstractTag {
    public static final String KEY = "component";
    public static final String NAME_PARAM = "name";
    public static final String VERSION_PARAM = "version";
    public static final String LIFESTYLE_PARAM = "lifestyle";
    public static final String LIFESTYLE_COLLECTION_PARAM = "collection";

    public TypeTag(JavaClass clazz) {
        super(clazz);
    }

    public Type getType() {
        DocletTag tag = this.getJavaClass().getTagByName(this.getNS() + "." + KEY);
        if (null == tag) {
            return null;
        }
        String name = this.getName(tag);
        Version version = this.getVersion(tag);
        String lifestyle = this.getLifestyle(tag);
        String collection = this.getLifestyleCollectionPolicy(tag);
        String type = this.getJavaClass().getFullyQualifiedName();
        Properties properties = new AttributeTag(this.getJavaClass()).getProperties();
        String schema = new SchemaTag(this.getJavaClass()).getConfigurationSchema();
        InfoDescriptor info = new InfoDescriptor(name, type, version, lifestyle, collection, schema, properties);
        SecurityDescriptor security = new SecurityTag(this.getJavaClass()).getSecurityDescriptor();
        ServiceDescriptor[] services = new ServicesTag(this.getJavaClass()).getServices();
        CategoryDescriptor[] loggers = new LoggerTag(this.getJavaClass()).getCategories();
        DependencyDescriptor[] dependencies = new DependencyTag(this.getJavaClass()).getDependencies();
        StageDescriptor[] stages = new StageTag(this.getJavaClass()).getStages();
        ExtensionDescriptor[] extensions = new ExtensionTag(this.getJavaClass()).getExtensions();
        ContextDescriptor context = new ContextTag(this.getJavaClass()).getContext();
        return new Type(info, security, loggers, context, services, dependencies, stages, extensions, null);
    }

    private String getName(DocletTag tag) {
        return this.getNamedParameter(tag, NAME_PARAM);
    }

    private String getLifestyle(DocletTag tag) {
        return this.getNamedParameter(tag, LIFESTYLE_PARAM, null);
    }

    private String getLifestyleCollectionPolicy(DocletTag tag) {
        return this.getNamedParameter(tag, LIFESTYLE_COLLECTION_PARAM, null);
    }

    private Version getVersion(DocletTag tag) {
        return Version.getVersion((String)this.getNamedParameter(tag, VERSION_PARAM, "1.0"));
    }
}

