/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder.tags;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import org.apache.avalon.meta.info.ExtensionDescriptor;
import org.apache.avalon.meta.info.builder.tags.AbstractTag;

public class ExtensionTag
extends AbstractTag {
    public static final String KEY = "extension";
    public static final String LEGACY_URN_PARAM = "urn";
    public static final String LEGACY_KEY_PARAM = "key";
    public static final String ID_PARAM = "id";

    public ExtensionTag(JavaClass clazz) {
        super(clazz);
    }

    public ExtensionDescriptor[] getExtensions() {
        ArrayList<ExtensionDescriptor> list = new ArrayList<ExtensionDescriptor>();
        DocletTag[] tags = this.getJavaClass().getTagsByName(this.getNS() + "." + KEY);
        for (int i = 0; i < tags.length; ++i) {
            list.add(this.getExtension(tags[i]));
        }
        return list.toArray(new ExtensionDescriptor[list.size()]);
    }

    private ExtensionDescriptor getExtension(DocletTag tag) {
        String value = this.getNamedParameter(tag, "type", null);
        if (value != null) {
            String type = this.resolveType(value);
            return new ExtensionDescriptor(type);
        }
        value = this.getNamedParameter(tag, LEGACY_KEY_PARAM, null);
        if (value == null) {
            value = this.getNamedParameter(tag, LEGACY_URN_PARAM, null);
        }
        if (value == null) {
            value = this.getNamedParameter(tag, ID_PARAM);
        }
        return new ExtensionDescriptor(value);
    }
}

