/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder.tags;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.Version;

public class AbstractTag {
    public static final String TYPE_PARAM = "type";
    public static final String VERSION_PARAM = "version";
    private JavaClass m_class;

    public AbstractTag(JavaClass clazz) {
        this.m_class = clazz;
    }

    protected JavaClass getJavaClass() {
        return this.m_class;
    }

    public String getNS() throws IllegalArgumentException {
        return "avalon";
    }

    public String getNSD() throws IllegalArgumentException {
        return this.getNS() + ".";
    }

    protected String getNamedParameter(DocletTag tag, String name, String defaultValue) {
        String value = tag.getNamedParameter(name);
        if (null == value) {
            return defaultValue;
        }
        if ((value = value.trim()).startsWith("\"") || value.startsWith("'")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"") || value.endsWith("'")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    protected String getNamedParameter(DocletTag tag, String name) {
        String value = this.getNamedParameter(tag, name, null);
        if (null == value) {
            String message = "Malformed tag '" + tag.getName() + "'. " + "Missing required parameter '" + name + "'";
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    protected Version resolveVersion(String version, String type) {
        if (version != null) {
            return Version.getVersion((String)version);
        }
        if (type.indexOf(":") > -1) {
            return Version.getVersion((String)type.substring(type.indexOf(":") + 1));
        }
        return null;
    }

    protected Version resolveVersion(String type) {
        if (type.indexOf(":") > -1) {
            return Version.getVersion((String)type.substring(type.indexOf(":") + 1));
        }
        return null;
    }

    protected String resolveType(String type) {
        String resolvedType = type.indexOf(":") > -1 ? this.doResolveType(this.getJavaClass(), type.substring(0, type.indexOf(":"))) : this.doResolveType(this.getJavaClass(), type);
        if (resolvedType == null) {
            String message = "Unable to find type " + type + " in class " + this.getJavaClass().getFullyQualifiedName();
            throw new RuntimeException(message);
        }
        return resolvedType;
    }

    private String doResolveType(JavaClass clazz, String type) {
        String resolvedType = clazz.getParentSource().resolveType(type);
        if (resolvedType != null) {
            return resolvedType;
        }
        if (clazz.getSuperJavaClass() == null) {
            return null;
        }
        return this.doResolveType(clazz.getSuperJavaClass(), type);
    }

    protected JavaMethod[] getLifecycleMethods(String methodName, String parameterType) {
        ArrayList result = new ArrayList();
        this.findLifecycleMethod(result, this.getJavaClass(), methodName, parameterType);
        return result.toArray(new JavaMethod[result.size()]);
    }

    private void findLifecycleMethod(List result, JavaClass clazz, String methodName, String parameterType) {
        JavaMethod[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod method = methods[i];
            if (!methodName.equals(method.getName()) || !method.getReturns().equals((Object)new Type("void", 0)) || method.getParameters().length != 1 || !method.getParameters()[0].getType().getValue().equals(parameterType)) continue;
            result.add(method);
            break;
        }
        if (clazz.getSuperJavaClass() != null) {
            this.findLifecycleMethod(result, clazz.getSuperJavaClass(), methodName, parameterType);
        }
    }

    JavaMethod[] findTaggedMethods(JavaClass clazz, String key) {
        ArrayList list = new ArrayList();
        return this.findTaggedMethods(clazz, key, list);
    }

    private JavaMethod[] findTaggedMethods(JavaClass clazz, String key, List list) {
        JavaMethod[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod method = methods[i];
            DocletTag tag = method.getTagByName(key);
            if (tag == null) continue;
            list.add(method);
        }
        if (clazz.getSuperJavaClass() != null) {
            return this.findTaggedMethods(clazz.getSuperJavaClass(), key, list);
        }
        return list.toArray(new JavaMethod[0]);
    }

    JavaMethod[] findConstructorMethods(JavaClass clazz, String key) {
        ArrayList list = new ArrayList();
        return this.findConstructorMethods(clazz, key, list);
    }

    private JavaMethod[] findConstructorMethods(JavaClass clazz, String key, List list) {
        JavaMethod[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            DocletTag tag;
            JavaMethod method = methods[i];
            if (!method.isConstructor() || !method.isPublic() || (tag = method.getTagByName(key)) == null) continue;
            list.add(method);
        }
        return list.toArray(new JavaMethod[0]);
    }
}

