/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.util.Properties;
import org.apache.avalon.framework.Version;
import org.apache.avalon.meta.info.Descriptor;

public final class InfoDescriptor
extends Descriptor {
    public static final String TRANSIENT = "transient";
    public static final String SINGLETON = "singleton";
    public static final String THREAD = "thread";
    public static final String POOLED = "pooled";
    public static final String LIBERAL_KEY = "liberal";
    public static final String DEMOCRAT_KEY = "democrat";
    public static final String CONSERVATIVE_KEY = "conservative";
    public static final int UNDEFINED = -1;
    public static final int LIBERAL = 0;
    public static final int DEMOCRAT = 1;
    public static final int CONSERVATIVE = 2;
    public static final String WEAK_KEY = "weak";
    public static final String SOFT_KEY = "soft";
    public static final String HARD_KEY = "hard";
    public static final int WEAK = 0;
    public static final int SOFT = 1;
    public static final int HARD = 2;
    private final String m_name;
    private final String m_classname;
    private final Version m_version;
    private final String m_lifestyle;
    private final String m_schema;
    private final int m_collection;

    public InfoDescriptor(String name, String classname, Version version, String lifestyle, String collection, String schema, Properties attributes) throws IllegalArgumentException {
        super(attributes);
        if (null == classname) {
            throw new NullPointerException("classname");
        }
        if (classname.indexOf("/") > -1) {
            throw new IllegalArgumentException("classname: " + classname);
        }
        this.m_classname = classname;
        this.m_version = version;
        this.m_schema = schema;
        if (lifestyle == null) {
            this.m_lifestyle = TRANSIENT;
        } else {
            this.validateLifestyle(lifestyle);
            this.m_lifestyle = lifestyle;
        }
        int p = InfoDescriptor.getCollectionPolicy(collection);
        this.m_collection = p > -1 ? (this.m_lifestyle == TRANSIENT && p == 2 ? 1 : p) : (this.m_lifestyle == TRANSIENT ? 1 : 2);
        this.m_name = name != null ? name : this.getClassName(classname);
    }

    private void validateLifestyle(String lifestyle) throws IllegalArgumentException {
        if (lifestyle.equals(TRANSIENT) || lifestyle.equals(SINGLETON) || lifestyle.equals(THREAD) || lifestyle.equals(POOLED)) {
            return;
        }
        String error = "Lifestyle policy not recognized: " + lifestyle;
        throw new IllegalArgumentException(error);
    }

    private String getClassName(String classname) {
        int i = classname.lastIndexOf(".");
        if (i == -1) {
            return classname.toLowerCase();
        }
        return classname.substring(i + 1, classname.length()).toLowerCase();
    }

    public String getName() {
        return this.m_name;
    }

    public int getCollectionPolicy() {
        return this.m_collection;
    }

    public boolean isLiberal() {
        return this.m_collection == 0;
    }

    public boolean isDemocrat() {
        return this.m_collection == 1;
    }

    public boolean isConservative() {
        return this.m_collection == 2;
    }

    public String getConfigurationSchema() {
        return this.m_schema;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public String getLifestyle() {
        return this.m_lifestyle;
    }

    public String toString() {
        return "[" + this.getName() + "] " + this.getClassname() + ":" + this.getVersion();
    }

    public boolean equals(Object other) {
        boolean isEqual;
        boolean bl = isEqual = super.equals(other) && other instanceof InfoDescriptor;
        if (isEqual) {
            InfoDescriptor info = (InfoDescriptor)other;
            isEqual = isEqual && this.m_classname.equals(info.m_classname);
            isEqual = isEqual && this.m_collection == info.m_collection;
            isEqual = isEqual && this.m_name.equals(info.m_name);
            boolean bl2 = isEqual = isEqual && this.m_lifestyle.equals(info.m_lifestyle);
            isEqual = null == this.m_version ? isEqual && null == info.m_version : isEqual && this.m_version.equals(info.m_version);
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash >>>= 7;
        hash ^= this.m_classname.hashCode();
        hash >>>= 7;
        if (null != this.m_name) {
            hash >>>= 7;
            hash ^= this.m_name.hashCode();
        }
        if (null != this.m_lifestyle) {
            hash >>>= 7;
            hash ^= this.m_lifestyle.hashCode();
        }
        if (null != this.m_version) {
            hash >>>= 7;
            hash ^= this.m_version.hashCode();
        }
        return hash;
    }

    public static String getCollectionPolicyKey(int policy) {
        if (policy == -1) {
            return null;
        }
        if (policy == 2) {
            return HARD_KEY;
        }
        if (policy == 1) {
            return SOFT_KEY;
        }
        if (policy == 0) {
            return WEAK_KEY;
        }
        String error = "Unrecognized collection argument [" + policy + "]";
        throw new IllegalArgumentException(error);
    }

    public static int getCollectionPolicy(String policy) {
        if (policy == null) {
            return -1;
        }
        if (policy.equalsIgnoreCase(CONSERVATIVE_KEY) || policy.equalsIgnoreCase(HARD_KEY)) {
            return 2;
        }
        if (policy.equalsIgnoreCase(DEMOCRAT_KEY) || policy.equalsIgnoreCase(SOFT_KEY)) {
            return 1;
        }
        if (policy.equalsIgnoreCase(LIBERAL_KEY) || policy.equalsIgnoreCase(WEAK_KEY)) {
            return 0;
        }
        String error = "Unrecognized collection argument [" + policy + "]";
        throw new IllegalArgumentException(error);
    }
}

