/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.util.Properties;
import org.apache.avalon.framework.Version;
import org.apache.avalon.meta.info.Descriptor;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;

public class Service
extends Descriptor {
    private final ReferenceDescriptor m_reference;
    private final EntryDescriptor[] m_entries;

    public Service(ReferenceDescriptor reference) {
        this(reference, null, null);
    }

    public Service(ReferenceDescriptor reference, EntryDescriptor[] entries) {
        this(reference, entries, null);
    }

    public Service(ReferenceDescriptor reference, Properties attributes) {
        this(reference, null, attributes);
    }

    public Service(ReferenceDescriptor reference, EntryDescriptor[] entries, Properties attributes) {
        super(attributes);
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        this.m_reference = reference;
        this.m_entries = entries == null ? new EntryDescriptor[0] : entries;
    }

    public String getClassname() {
        return this.m_reference.getClassname();
    }

    public Version getVersion() {
        return this.m_reference.getVersion();
    }

    public ReferenceDescriptor getReference() {
        return this.m_reference;
    }

    public EntryDescriptor[] getEntries() {
        return this.m_entries;
    }

    public boolean matches(ReferenceDescriptor reference) {
        return this.m_reference.matches(reference);
    }

    public int hashCode() {
        return this.m_reference.hashCode();
    }

    public boolean equals(Object other) {
        boolean match = false;
        if (other instanceof ReferenceDescriptor) {
            match = this.matches((ReferenceDescriptor)other);
        } else if (other instanceof Service) {
            Service ref = (Service)other;
            match = ref.getClassname().equals(this.getClassname()) && ref.getVersion().complies(this.getVersion());
        }
        return match;
    }

    public String toString() {
        return this.getReference().toString();
    }
}

