/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Descriptor
implements Serializable {
    private static final String[] EMPTY_SET = new String[0];
    private final Properties m_attributes;

    protected Descriptor(Properties attributes) {
        this.m_attributes = attributes;
    }

    public String getAttribute(String key) {
        if (null == this.m_attributes) {
            return null;
        }
        return this.m_attributes.getProperty(key);
    }

    public String getAttribute(String key, String defaultValue) {
        if (null == this.m_attributes) {
            return defaultValue;
        }
        return this.m_attributes.getProperty(key, defaultValue);
    }

    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return EMPTY_SET;
        }
        return ((Hashtable)this.m_attributes).keySet().toArray(EMPTY_SET);
    }

    public boolean equals(Object other) {
        if (other instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)other;
            if (null == this.m_attributes) {
                return null == descriptor.m_attributes;
            }
            return ((Hashtable)this.m_attributes).equals(descriptor.m_attributes);
        }
        return false;
    }

    public int hashCode() {
        if (this.m_attributes != null) {
            return ((Hashtable)this.m_attributes).hashCode();
        }
        return 1;
    }

    protected Properties getProperties() {
        return this.m_attributes;
    }
}

