/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.util.Properties;
import org.apache.avalon.framework.Version;
import org.apache.avalon.meta.info.Descriptor;

public final class InfoDescriptor
extends Descriptor {
    public static final String TRANSIENT = "transient";
    public static final String SINGLETON = "singleton";
    public static final String THREAD = "thread";
    public static final String POOLED = "pooled";
    private final String m_name;
    private final String m_classname;
    private final Version m_version;
    private final String m_lifestyle;
    private final String m_schema;

    public InfoDescriptor(String classname) throws IllegalArgumentException {
        this(null, classname, null, null, null, null);
    }

    public InfoDescriptor(String name, String classname, Version version, String lifestyle, String schema, Properties attributes) throws IllegalArgumentException {
        super(attributes);
        if (null == classname) {
            throw new NullPointerException("classname");
        }
        if (classname.indexOf("/") > -1) {
            throw new IllegalArgumentException("classname: " + classname);
        }
        this.m_classname = classname;
        this.m_version = version;
        this.m_schema = schema;
        if (lifestyle == null) {
            this.m_lifestyle = TRANSIENT;
        } else {
            this.validateLifestyle(lifestyle);
            this.m_lifestyle = lifestyle;
        }
        this.m_name = name != null ? name : this.getClassName(classname);
    }

    private void validateLifestyle(String lifestyle) throws IllegalArgumentException {
        if (lifestyle.equals(TRANSIENT) || lifestyle.equals(SINGLETON) || lifestyle.equals(THREAD) || lifestyle.equals(POOLED)) {
            return;
        }
        String error = "Lifestyle policy not recognized: " + lifestyle;
        throw new IllegalArgumentException(error);
    }

    private String getClassName(String classname) {
        int i = classname.lastIndexOf(".");
        if (i == -1) {
            return classname.toLowerCase();
        }
        return classname.substring(i + 1, classname.length()).toLowerCase();
    }

    public String getName() {
        return this.m_name;
    }

    public String getConfigurationSchema() {
        return this.m_schema;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public String getLifestyle() {
        return this.m_lifestyle;
    }

    public String toString() {
        return "[" + this.getName() + "] " + this.getClassname() + ":" + this.getVersion();
    }

    public boolean equals(Object other) {
        boolean isEqual;
        boolean bl = isEqual = super.equals(other) && other instanceof InfoDescriptor;
        if (isEqual) {
            InfoDescriptor info = (InfoDescriptor)other;
            isEqual = isEqual && this.m_classname.equals(info.m_classname);
            isEqual = isEqual && this.m_name.equals(info.m_name);
            boolean bl2 = isEqual = isEqual && this.m_lifestyle.equals(info.m_lifestyle);
            isEqual = null == this.m_version ? isEqual && null == info.m_version : isEqual && this.m_version.equals(info.m_version);
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash >>>= 7;
        hash ^= this.m_classname.hashCode();
        hash >>>= 7;
        if (null != this.m_name) {
            hash >>>= 7;
            hash ^= this.m_name.hashCode();
        }
        if (null != this.m_lifestyle) {
            hash >>>= 7;
            hash ^= this.m_lifestyle.hashCode();
        }
        if (null != this.m_version) {
            hash >>>= 7;
            hash ^= this.m_version.hashCode();
        }
        return hash;
    }
}

