/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit.factory.socket;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.logging.logkit.LogTargetException;
import org.apache.avalon.logging.logkit.LogTargetFactory;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log.LogTarget;
import org.apache.log.output.net.SocketOutputTarget;

public class SocketTargetFactory
implements LogTargetFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$factory$socket$SocketTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$socket$SocketTargetFactory = SocketTargetFactory.class$("org.apache.avalon.logging.logkit.factory.socket.SocketTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$socket$SocketTargetFactory));
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$socket$SocketTargetFactory;

    public LogTarget createTarget(Configuration conf) throws LogTargetException {
        InetAddress address;
        Configuration configChild = conf.getChild("address", false);
        if (null == configChild) {
            String error = REZ.getString("socket.error.missing-address");
            throw new LogTargetException(error);
        }
        try {
            address = InetAddress.getByName(configChild.getAttribute("hostname"));
        }
        catch (UnknownHostException uhex) {
            String error = REZ.getString("socket.error.unknown-host");
            throw new LogTargetException(error, (Throwable)uhex);
        }
        catch (ConfigurationException e) {
            String error = REZ.getString("socket.error.missing-host");
            throw new LogTargetException(error, (Throwable)e);
        }
        try {
            int port = configChild.getAttributeAsInteger("port");
            return new SocketOutputTarget(address, port);
        }
        catch (ConfigurationException e) {
            String error = REZ.getString("socket.error.missing-port");
            throw new LogTargetException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = REZ.getString("socket.error.internal");
            throw new LogTargetException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

