/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit.factory;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.logging.logkit.LogTargetException;
import org.apache.avalon.logging.logkit.LogTargetFactory;
import org.apache.avalon.logging.logkit.LogTargetFactoryBuilder;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.provider.Builder;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log.LogTarget;

public class PluginTargetFactory
implements LogTargetFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$factory$PluginTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$PluginTargetFactory = PluginTargetFactory.class$("org.apache.avalon.logging.logkit.factory.PluginTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$PluginTargetFactory));
    private final LogTargetFactoryBuilder m_builder;
    private final ClassLoader m_classloader;
    private final InitialContext m_context;
    private final Map m_factories = new HashMap();
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$PluginTargetFactory;

    public PluginTargetFactory(ClassLoader classloader, InitialContext context, LogTargetFactoryBuilder builder) {
        this.m_builder = builder;
        this.m_classloader = classloader;
        this.m_context = context;
    }

    public LogTarget createTarget(Configuration config) throws LogTargetException {
        String spec = config.getAttribute("artifact", null);
        if (null == spec) {
            String error = REZ.getString("plugin.error.missing-artifact");
            throw new LogTargetException(error);
        }
        LogTargetFactory factory = this.getLogTargetFactory(spec);
        return factory.createTarget(config);
    }

    private LogTargetFactory getLogTargetFactory(String spec) throws LogTargetException {
        if (this.m_factories.containsKey(spec)) {
            return (LogTargetFactory)this.m_factories.get(spec);
        }
        try {
            String uri = "artifact:" + spec;
            Artifact artifact = Artifact.createArtifact((String)uri);
            Builder builder = this.m_context.newBuilder(this.m_classloader, artifact);
            Class clazz = builder.getFactoryClass();
            LogTargetFactory factory = this.m_builder.buildLogTargetFactory(clazz);
            this.m_factories.put(spec, factory);
            return factory;
        }
        catch (Throwable e) {
            String error = REZ.getString("plugin.error.build", (Object)spec);
            throw new LogTargetException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

