/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit;

import org.apache.avalon.util.exception.ExceptionHelper;
import org.apache.log.LogEvent;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.util.StackIntrospector;

public class StandardFormatter
extends ExtendedPatternFormatter {
    private static final int TYPE_CLASS = 9;
    private static final String TYPE_CLASS_STR = "class";
    private static final String TYPE_CLASS_SHORT_STR = "short";
    public static final boolean DEFAULT_STACKTRACE_POLICY = true;
    private final boolean m_stacktrace;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Logger;

    public StandardFormatter(String pattern) {
        this(pattern, true);
    }

    public StandardFormatter(String pattern, boolean trace) {
        super(pattern);
        this.m_stacktrace = trace;
    }

    protected String getStackTrace(Throwable throwable, String format) {
        if (null == throwable) {
            return "";
        }
        return ExceptionHelper.packException((Throwable)throwable, (boolean)this.m_stacktrace);
    }

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_CLASS_STR)) {
            return 9;
        }
        return super.getTypeIdFor(type);
    }

    protected String formatPatternRun(LogEvent event, PatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getClass(run.m_format);
            }
        }
        return super.formatPatternRun(event, run);
    }

    private String getClass(String format) {
        int pos;
        Class clazz = StackIntrospector.getCallerClass((Class)(class$org$apache$avalon$framework$logger$Logger == null ? (class$org$apache$avalon$framework$logger$Logger = StandardFormatter.class$("org.apache.avalon.framework.logger.Logger")) : class$org$apache$avalon$framework$logger$Logger));
        if (null == clazz) {
            return "Unknown-class";
        }
        String className = clazz.getName();
        if (TYPE_CLASS_SHORT_STR.equalsIgnoreCase(format) && (pos = className.lastIndexOf(46)) >= 0) {
            className = className.substring(pos + 1);
        }
        return className;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

