/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.logging.impl.ConfigurationParameter;
import org.apache.avalon.logging.impl.ConsoleLogger;
import org.apache.avalon.logging.impl.LoggerParameter;
import org.apache.avalon.logging.provider.LoggingCriteria;
import org.apache.avalon.logging.provider.LoggingRuntimeException;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.criteria.Criteria;
import org.apache.avalon.util.criteria.Parameter;
import org.apache.avalon.util.defaults.Defaults;
import org.apache.avalon.util.defaults.DefaultsBuilder;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultLoggingCriteria
extends Criteria
implements LoggingCriteria {
    private static final String[] KEYS = new String[]{"avalon.logging.configuration", "avalon.logging.basedir", "avalon.logging.debug", "avalon.logging.bootstrap", "avalon.logging.update"};
    private static final String DEFAULTS = "/avalon.logging.properties";
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$impl$DefaultLoggingCriteria == null ? (class$org$apache$avalon$logging$impl$DefaultLoggingCriteria = DefaultLoggingCriteria.class$("org.apache.avalon.logging.impl.DefaultLoggingCriteria")) : class$org$apache$avalon$logging$impl$DefaultLoggingCriteria));
    private final InitialContext m_context;
    static /* synthetic */ Class class$org$apache$avalon$logging$impl$DefaultLoggingCriteria;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$org$apache$avalon$logging$provider$LoggingCriteria;

    private static Parameter[] buildParameters(InitialContext context) {
        return new Parameter[]{new ConfigurationParameter("avalon.logging.configuration"), new Parameter("avalon.logging.basedir", class$java$io$File == null ? (class$java$io$File = DefaultLoggingCriteria.class$("java.io.File")) : class$java$io$File, (Object)context.getInitialWorkingDirectory()), new Parameter("avalon.logging.debug", class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultLoggingCriteria.class$("java.lang.Boolean")) : class$java$lang$Boolean, (Object)new Boolean(false)), new LoggerParameter("avalon.logging.bootstrap", new ConsoleLogger(2)), new Parameter("avalon.logging.update", class$java$lang$Long == null ? (class$java$lang$Long = DefaultLoggingCriteria.class$("java.lang.Long")) : class$java$lang$Long, (Object)new Long(-1L))};
    }

    public DefaultLoggingCriteria(InitialContext context) {
        super(DefaultLoggingCriteria.buildParameters(context));
        this.m_context = context;
        try {
            String key = context.getApplicationKey();
            File work = context.getInitialWorkingDirectory();
            DefaultsBuilder builder = new DefaultsBuilder(key, work);
            Properties defaults = Defaults.getStaticProperties((Class)(class$org$apache$avalon$logging$provider$LoggingCriteria == null ? (class$org$apache$avalon$logging$provider$LoggingCriteria = DefaultLoggingCriteria.class$("org.apache.avalon.logging.provider.LoggingCriteria")) : class$org$apache$avalon$logging$provider$LoggingCriteria));
            String[] keys = super.getKeys();
            Properties properties = builder.getConsolidatedProperties(defaults, keys);
            for (int i = 0; i < keys.length; ++i) {
                String propertyKey = keys[i];
                String value = properties.getProperty(propertyKey);
                if (null == value) continue;
                this.put(propertyKey, value);
            }
        }
        catch (IOException e) {
            throw new LoggingRuntimeException("Failed to load implementation default resources.", (Throwable)e);
        }
    }

    public void setDebugEnabled(boolean mode) {
        this.put("avalon.logging.debug", new Boolean(mode));
    }

    public void setBootstrapLogger(Logger logger) {
        this.put("avalon.logging.bootstrap", logger);
    }

    public void setBaseDirectory(File dir) {
        this.put("avalon.logging.basedir", dir);
    }

    public void setLoggingConfiguration(URL url) {
        this.put("avalon.logging.configuration", url);
    }

    public Logger getBootstrapLogger() {
        return (Logger)this.get("avalon.logging.bootstrap");
    }

    public File getBaseDirectory() {
        return (File)this.get("avalon.logging.basedir");
    }

    public boolean isDebugEnabled() {
        Boolean value = (Boolean)this.get("avalon.logging.debug");
        if (null != value) {
            return value;
        }
        return false;
    }

    public URL getLoggingConfiguration() {
        return (URL)this.get("avalon.logging.configuration");
    }

    public long getUpdateInterval() {
        Long value = (Long)this.get("avalon.logging.update");
        if (null != value) {
            return value;
        }
        return -1L;
    }

    private static File getCanonicalForm(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (Throwable e) {
            String error = REZ.getString("criteria.artifact.cononical.error", (Object)file.toString());
            throw new LoggingRuntimeException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

