/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.merlin.http;

import java.io.File;
import java.util.HashMap;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.merlin.http.WebServer;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.SunJsseListener;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.MultiException;

public class JettyWebServer
extends AbstractLogEnabled
implements Contextualizable,
Configurable,
Initializable,
Serviceable,
Startable,
Disposable,
WebServer {
    protected Context m_context;
    protected Configuration m_config;
    protected Logger m_logger;
    protected HttpServer m_httpServer;
    protected ServiceManager m_serviceManager;
    protected HashMap m_listeners = new HashMap();
    protected String m_basedir = System.getProperty("merlin.home", System.getProperty("user.dir"));
    protected static final String CFG_LISTENER = "Listener";
    protected static final String CFG_LISTENER_NAME = "name";
    protected static final String CFG_LISTENER_PORT = "port";
    protected static final String CFG_LISTENER_HOST = "host";
    protected static final String CFG_LISTENER_TYPE = "type";
    protected static final String CFG_LISTENER_AUTO = "auto-start";
    protected static final String CFG_LISTENER_TYPE_SOCKET = "socket";
    protected static final String CFG_LISTENER_TYPE_AJP = "ajp";
    protected static final String CFG_LISTENER_TYPE_JSSE = "jsse";
    protected static final String CFG_LISTENER_TIMEOUT = "timeout";
    protected static final String CFG_CONTEXT = "Context";
    protected static final String CFG_CONTEXT_PATH = "path";
    protected static final String CFG_CONTEXT_NAME = "name";
    protected static final String CFG_SERVLET = "Servlet";
    protected static final String CFG_SERVLET_NAME = "name";
    protected static final String CFG_SERVLET_PATH = "path";
    protected static final String CFG_SERVLET_CLASSNAME = "classname";
    protected static final String CFG_WEB_CONTEXT = "WebContext";
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$SessionManager;
    static /* synthetic */ Class class$org$apache$avalon$merlin$http$SessionManager;

    public void contextualize(Context context) throws ContextException {
        block11: {
            this.m_context = context;
            this.m_logger = this.getLogger();
            if (this.m_logger.isInfoEnabled()) {
                this.m_logger.info("Contextualizing...");
            }
            try {
                File home;
                block10: {
                    home = null;
                    try {
                        home = (File)context.get((Object)"app.home");
                    }
                    catch (ContextException ce) {
                        if (this.m_logger.isWarnEnabled()) {
                            this.m_logger.warn("'app.home' key not found in context; trying 'urn:avalon:home'");
                        }
                        try {
                            home = (File)context.get((Object)"urn:avalon:home");
                        }
                        catch (ContextException cex) {
                            if (!this.m_logger.isWarnEnabled()) break block10;
                            this.m_logger.warn("'urn:avalon:home' key not found in context; using default");
                        }
                    }
                }
                if (home != null) {
                    this.m_basedir = home.getAbsolutePath();
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Setting home directory to: " + this.m_basedir);
                }
            }
            catch (Exception e) {
                if (!this.m_logger.isWarnEnabled()) break block11;
                this.m_logger.warn("Error attempting to establish home directory. Using default.", (Throwable)e);
            }
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        if (this.m_logger.isInfoEnabled()) {
            this.m_logger.info("Servicing...");
        }
        this.m_serviceManager = manager;
    }

    public void configure(Configuration config) throws ConfigurationException {
        if (this.m_logger.isInfoEnabled()) {
            this.m_logger.info("Configuring...");
        }
        this.m_config = config;
    }

    public void initialize() throws Exception {
        if (this.m_logger.isInfoEnabled()) {
            this.m_logger.info("Initializing...");
        }
        this.m_httpServer = new HttpServer();
        this.loadListeners();
        this.loadContexts();
        this.loadWebApplications();
    }

    public void start() throws Exception {
        if (this.m_logger.isInfoEnabled()) {
            this.m_logger.info("Starting...");
        }
        this.m_httpServer.start();
    }

    public void stop() throws Exception {
        if (this.m_logger.isInfoEnabled()) {
            this.m_logger.info("Shutting down...");
        }
        this.m_httpServer.stop(true);
    }

    public void dispose() {
        this.m_context = null;
        this.m_serviceManager = null;
        this.m_httpServer = null;
        this.m_listeners = null;
    }

    public void deployWebApplication(String context, String appPath) {
        this.loadWebApplicationContext(context, appPath);
    }

    public boolean removeWebApplication(String context) {
        try {
            this.m_httpServer.stop();
            HttpContext ctx = this.m_httpServer.getContext(context);
            if (ctx == null) {
                this.m_logger.error("Could not find application to remove: " + context);
                return false;
            }
            this.m_httpServer.removeContext(ctx);
            this.m_httpServer.start();
        }
        catch (InterruptedException e) {
            this.m_logger.error("Unable to remove web application due to: " + e.getMessage());
            return false;
        }
        catch (MultiException e) {
            this.m_logger.error("Unable to re-start web application due to: " + e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startListener(String name) throws Exception {
        boolean found = false;
        boolean started = false;
        this.m_logger.debug("Attempting to start listener " + name);
        if (this.m_listeners.containsKey(name)) {
            this.m_logger.debug("Retrieving listener " + name + " from lookup table...");
            HttpListener listener = (HttpListener)this.m_listeners.get(name);
            this.m_logger.debug("Listener " + name + " retrieved");
            if (listener == null) {
                this.m_logger.debug("Listener " + name + " has not yet been created/started");
                Configuration[] listeners = this.m_config.getChildren(CFG_LISTENER);
                this.m_logger.debug("Searching for listener " + name + "'s configuration...");
                for (int i = 0; i < listeners.length; ++i) {
                    Configuration conf = listeners[i];
                    String alias = conf.getAttribute("name");
                    if (!alias.equals(name)) continue;
                    found = true;
                    this.m_logger.debug("Found configuration for listener " + name);
                    this.m_logger.debug("Loading listener " + name + "...");
                    listener = this.loadListener(conf);
                    if (listener == null) break;
                    this.m_logger.debug("Listener " + name + " loaded");
                    listener.setHttpServer(this.m_httpServer);
                    this.m_logger.debug("Registered the listener with Jetty...");
                    if (listener.isStarted()) break;
                    this.m_logger.debug("Starting listener " + name);
                    listener.start();
                    this.m_logger.debug("Listener " + name + " started");
                    started = true;
                    this.m_listeners.put(name, listener);
                    this.m_logger.debug("Listener " + name + " stored in lookup table");
                    break;
                }
                if (!found) {
                    String errmsg = "Listener name [" + name + "] cannot be started because configuration not found";
                    this.m_logger.warn(errmsg);
                    throw new Exception(errmsg);
                }
                if (started) return;
                String errmsg = "Listener name [" + name + "] cannot be started because of unknown listener name";
                this.m_logger.warn(errmsg);
                throw new Exception(errmsg);
            }
            String errmsg = "Listener name [" + name + "] cannot be started because it is already running";
            this.m_logger.warn(errmsg);
            throw new Exception(errmsg);
        }
        String errmsg = "Listener name [" + name + "] cannot be started because of unknown listener name";
        this.m_logger.warn(errmsg);
        throw new Exception(errmsg);
    }

    public void stopListener(String name) throws Exception {
        HttpListener listener;
        if (this.m_listeners.containsKey(name) && (listener = (HttpListener)this.m_listeners.get(name)) != null && listener.isStarted()) {
            listener.stop();
            this.m_listeners.put(name, null);
        }
    }

    protected HttpListener loadListener(Configuration conf) throws Exception {
        HttpListener listener = null;
        String listenerType = conf.getAttribute(CFG_LISTENER_TYPE, CFG_LISTENER_TYPE_SOCKET);
        if (listenerType.equals(CFG_LISTENER_TYPE_AJP)) {
            listener = this.createAJP13Listener(conf);
            listener.setPort(conf.getAttributeAsInteger(CFG_LISTENER_PORT, 2345));
            listener.setHost(conf.getAttribute(CFG_LISTENER_HOST, "0.0.0.0"));
        } else if (listenerType.equals(CFG_LISTENER_TYPE_JSSE)) {
            listener = this.createSunJsseListener(conf);
            listener.setPort(conf.getAttributeAsInteger(CFG_LISTENER_PORT, 8443));
            listener.setHost(conf.getAttribute(CFG_LISTENER_HOST, "0.0.0.0"));
        } else {
            listener = this.createSocketListener(conf);
            listener.setPort(conf.getAttributeAsInteger(CFG_LISTENER_PORT, 8080));
            listener.setHost(conf.getAttribute(CFG_LISTENER_HOST, "0.0.0.0"));
        }
        this.m_httpServer.addListener(listener);
        this.m_logger.info("Loaded listener: " + listener.getClass().getName() + " on " + listener.getHost() + ":" + listener.getPort());
        return listener;
    }

    private void loadListeners() throws Exception {
        Configuration[] listeners = this.m_config.getChildren(CFG_LISTENER);
        for (int i = 0; i < listeners.length; ++i) {
            boolean isAutoStart;
            Configuration conf = listeners[i];
            String name = conf.getAttribute("name", null);
            if (name != null) {
                this.m_listeners.put(name, null);
            }
            if (isAutoStart = conf.getAttributeAsBoolean(CFG_LISTENER_AUTO, true)) {
                try {
                    HttpListener listener = this.loadListener(conf);
                    if (name == null) continue;
                    this.m_listeners.put(name, listener);
                }
                catch (Exception e) {
                    this.m_logger.error("Could not create listner", (Throwable)e);
                }
                continue;
            }
            this.m_logger.error("Listener " + name + " will not be started");
        }
    }

    private void loadContexts() {
        Configuration[] contexts = this.m_config.getChildren(CFG_CONTEXT);
        for (int i = 0; i < contexts.length; ++i) {
            try {
                Configuration conf = contexts[i];
                HttpContext context = new HttpContext();
                context.setContextPath(conf.getAttribute("path", "/*"));
                this.m_httpServer.addContext(context);
                ServletHandler servletHandler = this.setSessionManager(context);
                Configuration[] servlets = conf.getChildren(CFG_SERVLET);
                for (int j = 0; j < servlets.length; ++j) {
                    Configuration servletCfg = servlets[j];
                    servletHandler.addServlet(servletCfg.getAttribute("name", servletCfg.getAttribute(CFG_SERVLET_CLASSNAME)), servletCfg.getAttribute("path", "/servlets/*"), servletCfg.getAttribute(CFG_SERVLET_CLASSNAME));
                }
                context.setResourceBase(this.m_basedir + "/" + conf.getAttribute("name"));
                context.addHandler((HttpHandler)new ResourceHandler());
                continue;
            }
            catch (Exception e) {
                this.m_logger.error("Could not construct context", (Throwable)e);
            }
        }
    }

    private void loadWebApplications() {
        Configuration[] confArr = this.m_config.getChildren(CFG_WEB_CONTEXT);
        for (int c = 0; c < confArr.length; ++c) {
            Configuration conf = confArr[c];
            this.loadWebApplicationContext(conf.getAttribute("name", ""), new File(this.m_basedir, conf.getAttribute("path", "")).toString());
        }
    }

    private ServletHandler setSessionManager(HttpContext context) throws ServiceException {
        HttpHandler[] handlers = context.getHandlers();
        ServletHandler servletHandler = null;
        if (handlers == null || handlers.length == 0) {
            servletHandler = new ServletHandler();
            context.addHandler((HttpHandler)servletHandler);
        } else {
            for (int c = 0; c < handlers.length; ++c) {
                if (!(handlers[c] instanceof ServletHandler)) continue;
                servletHandler = (ServletHandler)handlers[c];
                c = handlers.length;
            }
            if (servletHandler == null) {
                servletHandler = new ServletHandler();
                context.addHandler((HttpHandler)servletHandler);
            }
        }
        String clazzName = (class$org$mortbay$jetty$servlet$SessionManager == null ? (class$org$mortbay$jetty$servlet$SessionManager = JettyWebServer.class$("org.mortbay.jetty.servlet.SessionManager")) : class$org$mortbay$jetty$servlet$SessionManager).getName();
        SessionManager sessionManager = (SessionManager)this.m_serviceManager.lookup(clazzName);
        servletHandler.setSessionManager(sessionManager);
        return servletHandler;
    }

    private void loadWebApplicationContext(String contextName, String appURL) {
        WebApplicationContext wac;
        try {
            String ext;
            String filename;
            int index;
            wac = new WebApplicationContext(appURL);
            File app = new File(appURL);
            if (app.isFile() && (index = (filename = app.getName()).lastIndexOf(46)) != -1 && (ext = filename.substring(index + 1)).equalsIgnoreCase("war")) {
                wac.setExtractWAR(true);
            }
            wac.setContextPath("/" + contextName + "/*");
            String clazzName = (class$org$apache$avalon$merlin$http$SessionManager == null ? (class$org$apache$avalon$merlin$http$SessionManager = JettyWebServer.class$("org.apache.avalon.merlin.http.SessionManager")) : class$org$apache$avalon$merlin$http$SessionManager).getName();
            wac.getServletHandler().setSessionManager((SessionManager)this.m_serviceManager.lookup(clazzName));
        }
        catch (Exception e) {
            this.m_logger.error("Failed to load context: " + contextName);
            return;
        }
        this.m_httpServer.addContext((HttpContext)wac);
    }

    private HttpListener createAJP13Listener(Configuration config) {
        AJP13Listener listener = new AJP13Listener();
        listener.setMaxIdleTimeMs(config.getAttributeAsInteger(CFG_LISTENER_TIMEOUT, 60000));
        return listener;
    }

    private HttpListener createSocketListener(Configuration config) {
        SocketListener listener = new SocketListener();
        listener.setMaxIdleTimeMs(config.getAttributeAsInteger(CFG_LISTENER_TIMEOUT, 60000));
        return listener;
    }

    private HttpListener createSunJsseListener(Configuration configuration) throws Exception {
        SunJsseListener listener = new SunJsseListener();
        listener.setMaxIdleTimeMs(configuration.getAttributeAsInteger(CFG_LISTENER_TIMEOUT, 60000));
        Configuration ksconfig = configuration.getChild("keystore");
        String fileName = ksconfig.getChild("file").getValue("conf/.keystore");
        File configuredFile = new File(fileName);
        if (!configuredFile.isAbsolute()) {
            listener.setKeystore(new File(this.m_basedir, fileName).getAbsolutePath());
        } else {
            listener.setKeystore(configuredFile.getAbsolutePath());
        }
        listener.setPassword(ksconfig.getChild("password").getValue(null));
        listener.setKeyPassword(ksconfig.getChild("key-password").getValue(null));
        return listener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

