/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.activation.impl.ApplianceInvocationHandler;
import org.apache.avalon.activation.impl.BlockInvocationHandler;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.DependencyModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.FatalServiceException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

class DefaultServiceManager
implements ServiceManager {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$activation$impl$DefaultServiceManager == null ? (class$org$apache$avalon$activation$impl$DefaultServiceManager = DefaultServiceManager.class$("org.apache.avalon.activation.impl.DefaultServiceManager")) : class$org$apache$avalon$activation$impl$DefaultServiceManager));
    private final ComponentModel m_model;
    private final Logger m_logger;
    private final Hashtable m_table = new Hashtable();
    private final Map m_map;
    static /* synthetic */ Class class$org$apache$avalon$activation$impl$DefaultServiceManager;

    public DefaultServiceManager(ComponentModel model) {
        if (model == null) {
            throw new NullPointerException("model");
        }
        this.m_model = model;
        this.m_logger = model.getLogger();
        this.m_map = new Hashtable();
        DependencyModel[] dependencies = model.getDependencyModels();
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyModel dependency = dependencies[i];
            String key = dependency.getDependency().getKey();
            this.m_map.put(key, dependency);
        }
    }

    public boolean hasService(String key) {
        if (key == null) {
            return false;
        }
        return this.m_map.get(key) != null;
    }

    public Object lookup(String key) throws ServiceException {
        return this.lookup(key, -1L);
    }

    public Object lookup(String key, long timeout) throws ServiceException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!this.hasService(key)) {
            String error = "Unknown key: " + key;
            throw new ServiceException(key, error);
        }
        DependencyModel dependency = (DependencyModel)this.m_map.get(key);
        DeploymentModel provider = dependency.getProvider();
        if (null == provider) {
            String error = REZ.getString("service.error.null-provider", (Object)key);
            throw new IllegalStateException(error);
        }
        try {
            Object instance = provider.resolve();
            if (Proxy.isProxyClass(instance.getClass())) {
                return instance;
            }
            String id = "" + System.identityHashCode(instance);
            this.m_table.put(id, key);
            if (this.getLogger().isDebugEnabled()) {
                String message = "resolved service [" + id + "] for the key [" + key + "].";
                this.getLogger().debug(message);
            }
            return instance;
        }
        catch (Throwable e) {
            String error = "Unexpected runtime error while attempting to resolve service for key: " + key;
            throw new FatalServiceException(key, error, e);
        }
    }

    public void release(Object instance) {
        String id;
        String key;
        if (instance == null) {
            return;
        }
        if (Proxy.isProxyClass(instance.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(instance);
            if (handler instanceof ApplianceInvocationHandler) {
                ApplianceInvocationHandler aic = (ApplianceInvocationHandler)handler;
                aic.release();
                return;
            }
            if (handler instanceof BlockInvocationHandler) {
                return;
            }
        }
        if ((key = (String)this.m_table.get(id = "" + System.identityHashCode(instance))) == null) {
            if (this.getLogger().isWarnEnabled()) {
                String warning = "Unrecognized object identity [" + id + "]. " + "Either this object was not provided by this service manager " + "or it has already been released.";
                this.getLogger().warn(warning);
            }
            return;
        }
        DependencyModel dependency = (DependencyModel)this.m_map.get(key);
        DeploymentModel provider = dependency.getProvider();
        if (provider == null) {
            if (this.getLogger().isErrorEnabled()) {
                String error = "Unable to release component as no provider could be found for the key [" + key + "].";
                this.getLogger().warn(error);
            }
            return;
        }
        provider.release(instance);
        if (this.getLogger().isDebugEnabled()) {
            String message = "released service [" + id + "] from the key [" + key + "].";
            this.getLogger().debug(message);
        }
        this.m_table.remove(id);
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

