/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.activation.Appliance;
import org.apache.avalon.activation.ApplianceRuntimeException;
import org.apache.avalon.activation.RuntimeFactory;
import org.apache.avalon.activation.RuntimeFactoryException;
import org.apache.avalon.activation.impl.DefaultAppliance;
import org.apache.avalon.activation.impl.DefaultBlock;
import org.apache.avalon.activation.impl.DefaultLifestyleFactory;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelRuntimeException;
import org.apache.avalon.composition.provider.LifestyleFactory;
import org.apache.avalon.composition.provider.LifestyleManager;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.provider.Builder;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultRuntimeFactory
implements RuntimeFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$activation$impl$DefaultRuntimeFactory == null ? (class$org$apache$avalon$activation$impl$DefaultRuntimeFactory = DefaultRuntimeFactory.class$("org.apache.avalon.activation.impl.DefaultRuntimeFactory")) : class$org$apache$avalon$activation$impl$DefaultRuntimeFactory));
    private final SystemContext m_system;
    private final Map m_map = new Hashtable();
    private final LifestyleFactory m_factory;
    private final boolean m_secure;
    static /* synthetic */ Class class$org$apache$avalon$activation$impl$DefaultRuntimeFactory;
    static /* synthetic */ Class class$org$apache$avalon$composition$provider$SystemContext;
    static /* synthetic */ Class class$org$apache$avalon$repository$provider$InitialContext;
    static /* synthetic */ Class class$org$apache$avalon$activation$RuntimeFactory;

    public DefaultRuntimeFactory(SystemContext system) {
        this.m_system = system;
        this.m_factory = new DefaultLifestyleFactory(this.m_system);
        this.m_secure = this.m_system.isCodeSecurityEnabled();
    }

    private LifestyleFactory getLifestyleFactory(SystemContext system, InitialContext context, Artifact artifact) throws RuntimeFactoryException {
        if (null == artifact) {
            return new DefaultLifestyleFactory(system);
        }
        try {
            ClassLoader classloader = (class$org$apache$avalon$activation$impl$DefaultRuntimeFactory == null ? (class$org$apache$avalon$activation$impl$DefaultRuntimeFactory = DefaultRuntimeFactory.class$("org.apache.avalon.activation.impl.DefaultRuntimeFactory")) : class$org$apache$avalon$activation$impl$DefaultRuntimeFactory).getClassLoader();
            Builder builder = context.newBuilder(classloader, artifact);
            Class candidate = builder.getFactoryClass();
            return this.buildLifestyleFactory(context, candidate);
        }
        catch (Throwable e) {
            String error = REZ.getString("system.error.load", (Object)artifact.toString());
            throw new RuntimeFactoryException(error, e);
        }
    }

    public LifestyleFactory buildLifestyleFactory(InitialContext context, Class clazz) throws RuntimeFactoryException {
        if (null == clazz) {
            throw new NullPointerException("clazz");
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length < 1) {
            String error = REZ.getString("runtime.error.lifestyle.no-constructor", (Object)clazz.getName());
            throw new RuntimeFactoryException(error);
        }
        Constructor<?> constructor = constructors[0];
        Class<?>[] classes = constructor.getParameterTypes();
        Object[] args = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<?> c;
            if ((class$org$apache$avalon$composition$provider$SystemContext == null ? DefaultRuntimeFactory.class$("org.apache.avalon.composition.provider.SystemContext") : class$org$apache$avalon$composition$provider$SystemContext).isAssignableFrom(c = classes[i])) {
                args[i] = this.m_system;
                continue;
            }
            if ((class$org$apache$avalon$repository$provider$InitialContext == null ? DefaultRuntimeFactory.class$("org.apache.avalon.repository.provider.InitialContext") : class$org$apache$avalon$repository$provider$InitialContext).isAssignableFrom(c)) {
                args[i] = context;
                continue;
            }
            if ((class$org$apache$avalon$activation$RuntimeFactory == null ? DefaultRuntimeFactory.class$("org.apache.avalon.activation.RuntimeFactory") : class$org$apache$avalon$activation$RuntimeFactory).isAssignableFrom(c)) {
                args[i] = this;
                continue;
            }
            String error = REZ.getString("runtime.error.unrecognized-runtime-parameter", (Object)c.getName(), (Object)clazz.getName());
            throw new RuntimeFactoryException(error);
        }
        return this.instantiateLifestyleFactory(constructor, args);
    }

    private LifestyleFactory instantiateLifestyleFactory(Constructor constructor, Object[] args) throws RuntimeFactoryException {
        Class clazz = constructor.getDeclaringClass();
        try {
            return (LifestyleFactory)constructor.newInstance(args);
        }
        catch (Throwable e) {
            String error = REZ.getString("runtime.error.lifestyle-instantiation", (Object)clazz.getName());
            throw new RuntimeFactoryException(error, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appliance getRuntime(DeploymentModel model) {
        Map map = this.m_map;
        synchronized (map) {
            Appliance runtime = this.getRegisteredRuntime(model);
            if (null != runtime) {
                return runtime;
            }
            if (model instanceof ComponentModel) {
                ComponentModel component = (ComponentModel)model;
                LifestyleManager manager = this.m_factory.createLifestyleManager(component);
                runtime = this.newComponentRuntime(component, manager);
            } else if (model instanceof ContainmentModel) {
                ContainmentModel containment = (ContainmentModel)model;
                runtime = this.newContainmentRuntime(containment);
            } else {
                String error = REZ.getString("runtime.error.unknown-model", (Object)model.toString(), (Object)model.getClass().getName());
                throw new ModelRuntimeException(error);
            }
            this.registerRuntime(model, runtime);
            return runtime;
        }
    }

    protected Appliance newComponentRuntime(ComponentModel model, LifestyleManager manager) {
        return new DefaultAppliance(model, manager, this.m_secure);
    }

    protected Appliance newContainmentRuntime(ContainmentModel model) throws ApplianceRuntimeException {
        return new DefaultBlock(this.m_system, model);
    }

    private Appliance getRegisteredRuntime(DeploymentModel model) {
        String name = model.getQualifiedName();
        return (Appliance)this.m_map.get(name);
    }

    private void registerRuntime(DeploymentModel model, Appliance runtime) {
        String name = model.getQualifiedName();
        this.m_map.put(name, runtime);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

