/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import org.apache.avalon.activation.ComponentFactory;
import org.apache.avalon.activation.impl.DefaultComponentFactory;
import org.apache.avalon.activation.impl.SingletonLifestyleManager;
import org.apache.avalon.activation.impl.ThreadLifestyleManager;
import org.apache.avalon.activation.impl.TransientLifestyleManager;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.provider.LifestyleFactory;
import org.apache.avalon.composition.provider.LifestyleManager;
import org.apache.avalon.composition.provider.SystemContext;

public class DefaultLifestyleFactory
implements LifestyleFactory {
    private final SystemContext m_system;

    public DefaultLifestyleFactory(SystemContext system) {
        this.m_system = system;
    }

    public LifestyleManager createLifestyleManager(ComponentModel model) {
        DefaultComponentFactory factory = new DefaultComponentFactory(this.m_system, model);
        return this.createLifestyleManager(model, factory);
    }

    protected LifestyleManager createLifestyleManager(ComponentModel model, ComponentFactory factory) {
        String lifestyle = model.getType().getInfo().getLifestyle();
        if (lifestyle.equals("singleton")) {
            return new SingletonLifestyleManager(model, factory);
        }
        if (lifestyle.equals("thread")) {
            return new ThreadLifestyleManager(model, factory);
        }
        if (lifestyle.equals("transient")) {
            return new TransientLifestyleManager(model, factory);
        }
        String error = "Unsupported lifestyle [" + lifestyle + "].";
        throw new IllegalArgumentException(error);
    }

    private ComponentFactory createComponentFactory(ComponentModel model) {
        return new DefaultComponentFactory(this.m_system, model);
    }
}

