/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.avalon.activation.ApplianceException;
import org.apache.avalon.activation.impl.AbstractAppliance;
import org.apache.avalon.activation.impl.ApplianceInvocationHandler;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.TransientRuntimeException;
import org.apache.avalon.composition.provider.LifestyleManager;
import org.apache.avalon.composition.util.DefaultState;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultAppliance
extends AbstractAppliance {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$activation$impl$DefaultAppliance == null ? (class$org$apache$avalon$activation$impl$DefaultAppliance = DefaultAppliance.class$("org.apache.avalon.activation.impl.DefaultAppliance")) : class$org$apache$avalon$activation$impl$DefaultAppliance));
    private final ComponentModel m_model;
    private final LifestyleManager m_lifestyle;
    private final DefaultState m_commissioned = new DefaultState();
    private long m_delay = 0L;
    private final boolean m_secure;
    static /* synthetic */ Class class$org$apache$avalon$activation$impl$DefaultAppliance;

    public DefaultAppliance(ComponentModel model, LifestyleManager lifestyle, boolean secure) {
        super((DeploymentModel)model);
        this.m_model = model;
        this.m_lifestyle = lifestyle;
        this.m_secure = secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commission() throws Exception {
        DefaultState defaultState = this.m_commissioned;
        synchronized (defaultState) {
            if (this.m_commissioned.isEnabled()) {
                return;
            }
            try {
                this.m_delay = this.m_model.getDeploymentTimeout();
                this.m_lifestyle.commission();
                this.m_delay = 0L;
                this.m_commissioned.setEnabled(true);
            }
            finally {
                this.m_delay = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decommission() {
        DefaultState defaultState = this.m_commissioned;
        synchronized (defaultState) {
            if (!this.m_commissioned.isEnabled()) {
                return;
            }
            this.m_lifestyle.decommission();
            this.m_commissioned.setEnabled(false);
        }
    }

    public Object resolve() throws Exception {
        if (this.getComponentModel().getType().getInfo().getAttribute("urn:activation:proxy", "true").equals("false")) {
            return this.resolve(false);
        }
        return this.resolve(true);
    }

    public Object resolve(boolean proxy) throws Exception {
        if (!proxy) {
            if (this.m_delay > 0L) {
                String error = REZ.getString("appliance.error.resolve.transient", (Object)this.toString(), (Object)("" + this.m_delay));
                throw new TransientRuntimeException(error, this.m_delay);
            }
            if (!this.m_commissioned.isEnabled()) {
                String error = REZ.getString("appliance.error.resolve.non-commission-state", (Object)this.toString());
                throw new IllegalStateException(error);
            }
            return this.m_lifestyle.resolve();
        }
        ComponentModel model = this.getComponentModel();
        Logger logger = model.getLogger().getChildLogger("proxy");
        ApplianceInvocationHandler handler = new ApplianceInvocationHandler(this, logger, this.m_secure);
        try {
            return Proxy.newProxyInstance(model.getDeploymentClass().getClassLoader(), model.getInterfaces(), (InvocationHandler)handler);
        }
        catch (Throwable e) {
            String error = "Proxy establishment failure in block: " + this;
            throw new ApplianceException(error, e);
        }
    }

    public void release(Object instance) {
        if (null == instance) {
            return;
        }
        if (!this.m_commissioned.isEnabled()) {
            return;
        }
        if (Proxy.isProxyClass(instance.getClass())) {
            ApplianceInvocationHandler handler = (ApplianceInvocationHandler)Proxy.getInvocationHandler(instance);
            handler.release();
        } else {
            this.m_lifestyle.release(instance);
        }
    }

    protected ComponentModel getComponentModel() {
        return this.m_model;
    }

    public String toString() {
        return "appliance:" + this.getComponentModel().getQualifiedName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

