/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.avalon.activation.ApplianceException;
import org.apache.avalon.activation.TransientApplianceException;
import org.apache.avalon.activation.impl.DefaultAppliance;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.Reclaimer;
import org.apache.avalon.composition.model.TransientRuntimeException;
import org.apache.avalon.framework.logger.Logger;

public final class ApplianceInvocationHandler
implements InvocationHandler,
Reclaimer {
    private final DefaultAppliance m_appliance;
    private final Logger m_logger;
    private final ComponentModel m_model;
    private final boolean m_secure;
    private Object m_instance;
    private boolean m_destroyed = false;

    protected ApplianceInvocationHandler(DefaultAppliance appliance, Logger logger, boolean secure) {
        this.assertNotNull(appliance, "appliance");
        this.assertNotNull(logger, "logger");
        this.m_appliance = appliance;
        this.m_logger = logger;
        this.m_secure = secure;
        this.m_model = this.m_appliance.getComponentModel();
    }

    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        if (proxy == null) {
            throw new NullPointerException("proxy");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (this.m_destroyed) {
            throw new IllegalStateException("destroyed");
        }
        try {
            final Object instance = this.getInstance();
            if (this.m_secure) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return method.invoke(instance, args);
                    }
                }, this.m_model.getAccessControlContext());
            }
            return method.invoke(instance, args);
        }
        catch (Throwable e) {
            throw this.handleInvocationThrowable(e);
        }
    }

    public void release() {
        if (!this.m_destroyed) {
            this.m_destroyed = true;
            String message = "Releasing component [" + System.identityHashCode(this.m_instance) + "] (" + this.m_appliance.toString() + ").";
            this.getLogger().debug(message);
            this.m_appliance.release(this.m_instance);
        }
    }

    protected void finalize() throws Throwable {
        if (!this.m_destroyed && null != this.m_instance) {
            String message = "Finalizing proxy [" + System.identityHashCode(this.m_instance) + "] (" + this.m_appliance.toString() + ").";
            this.getLogger().debug(message);
            this.release();
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private Object getInstance() throws Exception {
        if (this.m_instance == null) {
            this.m_instance = this.m_appliance.resolve(false);
        }
        return this.m_instance;
    }

    private Throwable handleInvocationThrowable(Throwable e) {
        String error = "Delegation error raised by component: " + this.m_appliance.toString();
        while (true) {
            Throwable cause;
            if (e instanceof TransientApplianceException) {
                TransientApplianceException t = (TransientApplianceException)e;
                return new TransientRuntimeException(t.getMessage(), t.getDelay());
            }
            if (e instanceof UndeclaredThrowableException) {
                cause = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
                if (cause == null) {
                    return new ApplianceException(error, e);
                }
                e = cause;
                continue;
            }
            if (e instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)e).getTargetException();
                if (cause == null) {
                    return new ApplianceException(error, e);
                }
                e = cause;
                continue;
            }
            if (!(e instanceof PrivilegedActionException)) break;
            cause = ((PrivilegedActionException)e).getException();
            if (cause == null) {
                return new ApplianceException(error, e);
            }
            e = cause;
        }
        return e;
    }

    private void assertNotNull(Object object, String key) {
        if (null == object) {
            throw new NullPointerException(key);
        }
    }
}

