/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import org.apache.avalon.activation.appliance.Appliance;
import org.apache.avalon.activation.appliance.ApplianceException;
import org.apache.avalon.activation.appliance.BlockContext;
import org.apache.avalon.activation.appliance.Home;
import org.apache.avalon.activation.appliance.impl.AbstractBlock;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.ServiceModel;
import org.apache.avalon.framework.logger.Logger;

public class CompositeBlock
extends AbstractBlock
implements Home {
    private final BlockContext m_context;
    private final Object m_proxy;

    CompositeBlock(BlockContext context) throws ApplianceException {
        super(context);
        this.m_context = context;
        try {
            Logger log = context.getLogger().getChildLogger("proxy");
            ContainmentModel model = context.getContainmentModel();
            BlockInvocationHandler handler = new BlockInvocationHandler(log, this);
            Class[] classes = this.getInterfaceClasses();
            this.m_proxy = Proxy.newProxyInstance(model.getClassLoaderModel().getClassLoader(), classes, (InvocationHandler)handler);
        }
        catch (Throwable e) {
            String error = "Composite service establishment failure in block: " + (Object)((Object)this);
            throw new ApplianceException(error, e);
        }
    }

    public Object resolve() throws Exception {
        return this.m_proxy;
    }

    public void release(Object instance) {
    }

    private Class[] getInterfaceClasses() throws Exception {
        ContainmentModel model = this.m_context.getContainmentModel();
        ArrayList<Class> list = new ArrayList<Class>();
        ServiceModel[] services = model.getServiceModels();
        for (int i = 0; i < services.length; ++i) {
            ServiceModel service = services[i];
            list.add(service.getServiceClass());
        }
        return list.toArray(new Class[0]);
    }

    final class BlockInvocationHandler
    implements InvocationHandler {
        private final CompositeBlock m_block;
        private final Logger m_logger;

        protected BlockInvocationHandler(Logger logger, CompositeBlock block) throws Exception {
            if (block == null) {
                throw new NullPointerException("block");
            }
            this.m_block = block;
            this.m_logger = logger;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> source;
            if (proxy == null) {
                throw new NullPointerException("proxy");
            }
            if (method == null) {
                throw new NullPointerException("method");
            }
            ContainmentModel model = CompositeBlock.this.m_context.getContainmentModel();
            ServiceModel service = model.getServiceModel(source = method.getDeclaringClass());
            if (null == service) {
                String error = "Unable to resolve an provider for the class [" + source.getName() + "].";
                throw new IllegalStateException(error);
            }
            String path = service.getServiceDirective().getPath();
            Appliance provider = this.m_block.locate(path);
            this.m_logger.debug("delegating: " + method.getName());
            try {
                Object object = provider.resolve();
                return method.invoke(object, args);
            }
            catch (UndeclaredThrowableException e) {
                Throwable cause = e.getUndeclaredThrowable();
                if (cause != null) {
                    throw cause;
                }
                String error = "Delegation error raised by component: " + (Object)((Object)this.m_block);
                throw new ApplianceException(error, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause != null) {
                    throw cause;
                }
                String error = "Delegation error raised by component: " + (Object)((Object)this.m_block);
                throw new ApplianceException(error, (Throwable)e);
            }
            catch (Throwable e) {
                String error = "Composite service resolution failure for the class: '" + method.getDeclaringClass() + "' for operation: '" + method.getName() + "' in appliance: " + (Object)((Object)this.m_block);
                throw new ApplianceException(error, e);
            }
        }
    }
}

