/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.avalon.activation.appliance.Appliance;
import org.apache.avalon.activation.appliance.ApplianceException;
import org.apache.avalon.activation.appliance.ApplianceRepository;
import org.apache.avalon.activation.appliance.ApplianceRuntimeException;
import org.apache.avalon.activation.appliance.AssemblyException;
import org.apache.avalon.activation.appliance.Block;
import org.apache.avalon.activation.appliance.BlockContext;
import org.apache.avalon.activation.appliance.Composite;
import org.apache.avalon.activation.appliance.DependencyGraph;
import org.apache.avalon.activation.appliance.DeploymentException;
import org.apache.avalon.activation.appliance.Engine;
import org.apache.avalon.activation.appliance.NoProviderDefinitionException;
import org.apache.avalon.activation.appliance.ServiceContext;
import org.apache.avalon.activation.appliance.impl.AbstractAppliance;
import org.apache.avalon.activation.appliance.impl.BlockThread;
import org.apache.avalon.activation.appliance.impl.CompositeBlock;
import org.apache.avalon.activation.appliance.impl.DefaultAppliance;
import org.apache.avalon.activation.appliance.impl.DefaultApplianceRepository;
import org.apache.avalon.activation.appliance.impl.DefaultBlockContext;
import org.apache.avalon.activation.appliance.impl.DefaultState;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.event.CompositionEvent;
import org.apache.avalon.composition.event.CompositionEventListener;
import org.apache.avalon.composition.logging.LoggingManager;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DependencyModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.Model;
import org.apache.avalon.composition.model.StageModel;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

public abstract class AbstractBlock
extends AbstractAppliance
implements Block,
Composite,
CompositionEventListener {
    private final BlockContext m_context;
    private final DefaultApplianceRepository m_repository;
    private final DefaultState m_assembly = new DefaultState();
    private final DefaultState m_deployment = new DefaultState();
    private final DefaultState m_self = new DefaultState();
    private final Hashtable m_threads = new Hashtable();

    public static Block createRootBlock(ServiceContext services, ContainmentModel model) throws Exception {
        Logger logger = services.getLoggingManager().getLoggerForCategory("");
        DefaultApplianceRepository repository = new DefaultApplianceRepository();
        DependencyGraph graph = new DependencyGraph();
        DefaultBlockContext context = new DefaultBlockContext(logger, model, graph, services, null, repository);
        return new CompositeBlock(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractBlock(BlockContext context) throws ApplianceException {
        super(context.getLogger(), (Model)context.getContainmentModel());
        ContainmentModel model;
        this.m_context = context;
        ApplianceRepository parent = context.getApplianceRepository();
        this.m_repository = new DefaultApplianceRepository(parent);
        this.m_repository.enableLogging(this.getLogger());
        this.m_self.setEnabled(true);
        ContainmentModel containmentModel = model = this.m_context.getContainmentModel();
        synchronized (containmentModel) {
            model.addCompositionListener((CompositionEventListener)this);
            Model[] models = model.getModels();
            for (int i = 0; i < models.length; ++i) {
                Appliance appliance = this.createAppliance(models[i]);
                this.m_repository.addAppliance(appliance);
            }
        }
    }

    public ContainmentModel getContainmentModel() {
        return this.m_context.getContainmentModel();
    }

    public void modelAdded(CompositionEvent event) {
        try {
            this.getLogger().debug("event/addition: " + event);
            Appliance appliance = this.createAppliance(event.getChild());
            this.m_repository.addAppliance(appliance);
        }
        catch (Throwable e) {
            String error = "An error occured while attempting to create an appliance in response to a composition event: " + event;
            throw new ApplianceRuntimeException(error, e);
        }
    }

    public void modelRemoved(CompositionEvent event) {
        this.getLogger().debug("event/removal: " + event);
        Model model = event.getChild();
        String name = model.getName();
        Appliance appliance = this.getLocalAppliance(name);
        this.m_context.getDependencyGraph().remove(appliance);
        this.m_repository.removeAppliance(appliance);
    }

    public Appliance locate(DependencyModel dependency) throws NoProviderDefinitionException, ApplianceException {
        String path = dependency.getPath();
        if (path != null) {
            return this.locate(path);
        }
        return this.locate(dependency.getDependency());
    }

    public Appliance locate(DependencyDescriptor dependency) throws NoProviderDefinitionException, ApplianceException {
        Appliance appliance;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("resolving provider for: " + dependency);
        }
        if ((appliance = this.m_repository.getAppliance(dependency)) != null) {
            return appliance;
        }
        Model model = this.m_context.getContainmentModel().getModel(dependency);
        if (model != null) {
            appliance = this.createAppliance(model);
            if (appliance instanceof Composite) {
                ((Composite)appliance).assemble();
            }
            this.m_repository.addAppliance(appliance);
            return appliance;
        }
        if (null != this.m_context.getEngine()) {
            return this.m_context.getEngine().locate(dependency);
        }
        if (dependency.isOptional()) {
            return null;
        }
        throw new NoProviderDefinitionException("Unable to resolve dependency: " + dependency);
    }

    public Appliance locate(StageModel stage) throws NoProviderDefinitionException, ApplianceException {
        String path = stage.getPath();
        if (path != null) {
            return this.locate(path);
        }
        return this.locate(stage.getStage());
    }

    public Appliance locate(StageDescriptor stage) throws NoProviderDefinitionException, ApplianceException {
        Appliance appliance;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("resolving stage provider for: " + stage);
        }
        if ((appliance = this.m_repository.getAppliance(stage)) != null) {
            return appliance;
        }
        Model model = this.m_context.getContainmentModel().getModel(stage);
        if (model != null) {
            appliance = this.createAppliance(model);
            if (appliance instanceof Composite) {
                ((Composite)appliance).assemble();
            }
            this.m_repository.addAppliance(appliance);
            return appliance;
        }
        if (this.m_context.getEngine() != null) {
            return this.m_context.getEngine().locate(stage);
        }
        throw new NoProviderDefinitionException("Unable to resolve stage handler for: " + stage);
    }

    public Appliance locate(String source) throws IllegalArgumentException, ApplianceException {
        String base;
        String path = source;
        if (source.length() > 1 && source.endsWith("/")) {
            path = source.substring(0, source.length() - 1);
        }
        if (path.equals(base = this.getModel().getQualifiedName())) {
            return this;
        }
        if (path.startsWith(base)) {
            String name = path.substring(base.length());
            int j = name.indexOf("/");
            if (j == -1) {
                return this.getLocalAppliance(name);
            }
            if (j == 0) {
                int d = name.lastIndexOf("/");
                if (d > j) {
                    String root = name.substring(1, d);
                    Appliance child = this.getLocalAppliance(root);
                    if (child instanceof Engine) {
                        return ((Engine)child).locate(name.substring(d + 1));
                    }
                    String error = "Not a container: /" + name;
                    throw new IllegalArgumentException(error);
                }
                return this.getLocalAppliance(name.substring(1));
            }
            String root = name.substring(0, j);
            Appliance child = this.getLocalAppliance(root);
            if (child instanceof Engine) {
                return ((Engine)child).locate(name.substring(j + 1));
            }
            String error = "Not a container: /" + name;
            throw new IllegalArgumentException(error);
        }
        if (base.startsWith(path)) {
            return this.parentLocate(path);
        }
        if (base.startsWith("../")) {
            String relative = base.substring(3);
            return this.getLocalAppliance(relative);
        }
        if (path.indexOf("/") < 0) {
            return this.getLocalAppliance(path);
        }
        return this.parentLocate(path);
    }

    private Appliance parentLocate(String path) throws IllegalArgumentException, ApplianceException {
        if (this.m_context.getEngine() != null) {
            return this.m_context.getEngine().locate(path);
        }
        String error = "Invalid absolute reference: [" + path + "]";
        throw new IllegalArgumentException(error);
    }

    private Appliance getLocalAppliance(String name) throws IllegalArgumentException {
        Appliance appliance = this.m_repository.getLocalAppliance(name);
        if (appliance != null) {
            return appliance;
        }
        String error = "Unknown name: [" + name + "]";
        throw new IllegalArgumentException(error);
    }

    public boolean isAssembled() {
        return this.m_assembly.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble() throws AssemblyException {
        DefaultState defaultState = this.m_assembly;
        synchronized (defaultState) {
            if (this.isAssembled()) {
                return;
            }
            this.getLogger().debug("assembly phase");
            Appliance[] appliances = this.m_repository.getAppliances();
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (!(appliance instanceof Composite)) continue;
                ((Composite)appliance).assemble();
            }
            this.m_assembly.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassemble() {
        DefaultState defaultState = this.m_assembly;
        synchronized (defaultState) {
            if (!this.isAssembled()) {
                return;
            }
            this.getLogger().debug("dissassembly phase");
            Appliance[] appliances = this.m_repository.getAppliances();
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (!(appliance instanceof Composite)) continue;
                ((Composite)appliance).disassemble();
            }
            this.m_assembly.setEnabled(false);
        }
    }

    public Appliance[] getProviders() {
        if (!this.isAssembled()) {
            throw new IllegalStateException("assembly");
        }
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        Appliance[] appliances = this.m_repository.getAppliances();
        for (int i = 0; i < appliances.length; ++i) {
            Appliance appliance = appliances[i];
            if (!(appliance instanceof Composite)) continue;
            Appliance[] providers = ((Composite)appliance).getProviders();
            for (int j = 0; j < providers.length; ++j) {
                String root;
                Appliance provider = providers[j];
                String path = provider.getModel().getPath();
                if (path.startsWith(root = this.m_context.getContainmentModel().getPartition())) continue;
                list.add(providers[j]);
            }
        }
        return list.toArray(new Appliance[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws Exception {
        if (!this.isAssembled()) {
            throw new IllegalStateException("assembly");
        }
        DefaultState defaultState = this.m_deployment;
        synchronized (defaultState) {
            if (this.m_deployment.isEnabled()) {
                return;
            }
            Appliance[] appliances = this.getLocalStartupSequence();
            if (this.getLogger().isDebugEnabled()) {
                String message = this.listAppliances("deployment: ", appliances);
                this.getLogger().debug(message);
            }
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (appliance instanceof Block) {
                    Block block = (Block)appliance;
                    BlockThread thread = new BlockThread(block);
                    this.m_threads.put(block, thread);
                    thread.start();
                    while (!thread.started()) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (Throwable e) {}
                    }
                    if (thread.getError() == null) continue;
                    String error = "Composite deployment failure in block: [" + block + "]";
                    throw new DeploymentException(error, thread.getError());
                }
                appliances[i].deploy();
            }
            this.m_deployment.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decommission() {
        if (!this.isAssembled()) {
            return;
        }
        DefaultState defaultState = this.m_deployment;
        synchronized (defaultState) {
            if (!this.m_deployment.isEnabled()) {
                return;
            }
            Appliance[] appliances = this.getLocalShutdownSequence();
            if (this.getLogger().isDebugEnabled()) {
                String message = this.listAppliances("decommissioning: ", appliances);
                this.getLogger().debug(message);
            }
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (appliance instanceof Block) {
                    BlockThread thread = (BlockThread)this.m_threads.get(appliance);
                    thread.decommission();
                    while (!thread.stopped()) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (Throwable e) {}
                    }
                    continue;
                }
                appliance.decommission();
            }
            this.m_deployment.setEnabled(false);
        }
    }

    public abstract Object resolve() throws Exception;

    public abstract void release(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DefaultState defaultState = this.m_self;
        synchronized (defaultState) {
            if (!this.m_self.isEnabled()) {
                return;
            }
            this.getLogger().debug("disposal phase");
            Appliance[] appliances = this.m_repository.getAppliances();
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                this.m_repository.removeAppliance(appliance);
                if (!(appliance instanceof Disposable)) continue;
                ((Disposable)appliance).dispose();
            }
            this.m_context.getContainmentModel().removeCompositionListener((CompositionEventListener)this);
            this.m_self.setEnabled(false);
        }
    }

    private Appliance[] getLocalStartupSequence() {
        DependencyGraph graph = this.m_context.getDependencyGraph();
        Appliance[] appliances = graph.getStartupGraph();
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        for (int i = 0; i < appliances.length; ++i) {
            String root;
            Appliance appliance = appliances[i];
            String path = appliance.getModel().getPath();
            if (!path.startsWith(root = this.m_context.getContainmentModel().getPartition())) continue;
            list.add(appliance);
        }
        return list.toArray(new Appliance[0]);
    }

    private Appliance[] getLocalShutdownSequence() {
        DependencyGraph graph = this.m_context.getDependencyGraph();
        Appliance[] appliances = graph.getShutdownGraph();
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        for (int i = 0; i < appliances.length; ++i) {
            String root;
            Appliance appliance = appliances[i];
            String path = appliance.getModel().getPath();
            if (!path.startsWith(root = this.m_context.getContainmentModel().getPartition())) continue;
            list.add(appliance);
        }
        return list.toArray(new Appliance[0]);
    }

    private String listAppliances(String header, Appliance[] appliances) {
        if (appliances.length > 0) {
            boolean flag = true;
            StringBuffer buffer = new StringBuffer(header);
            for (int i = 0; i < appliances.length; ++i) {
                if (flag) {
                    buffer.append(appliances[i]);
                    flag = false;
                    continue;
                }
                buffer.append(", " + appliances[i]);
            }
            return buffer.toString();
        }
        return new String(header + " (empty)");
    }

    public Appliance createAppliance(Model model) throws ApplianceException {
        AbstractAppliance appliance = null;
        String path = model.getPath() + model.getName();
        ServiceContext services = this.m_context.getServiceContext();
        LoggingManager logging = services.getLoggingManager();
        DependencyGraph graph = this.m_context.getDependencyGraph();
        if (model instanceof DeploymentModel) {
            this.getLogger().debug("creating appliance: " + path);
            DeploymentModel deployment = (DeploymentModel)model;
            CategoriesDirective categories = deployment.getCategories();
            if (categories != null) {
                logging.addCategories(path, categories);
            }
            Logger logger = logging.getLoggerForCategory(path);
            appliance = new DefaultAppliance(logger, services, deployment, (Engine)this);
        } else if (model instanceof ContainmentModel) {
            this.getLogger().debug("creating block: " + path);
            ContainmentModel containment = (ContainmentModel)model;
            CategoriesDirective categories = containment.getCategories();
            if (categories != null) {
                logging.addCategories(path, categories);
            }
            Logger logger = logging.getLoggerForCategory(path);
            DefaultApplianceRepository repository = new DefaultApplianceRepository(this.m_repository);
            repository.enableLogging(this.getLogger());
            DefaultBlockContext context = new DefaultBlockContext(logger, containment, new DependencyGraph(graph), services, (Engine)this, repository);
            appliance = new CompositeBlock(context);
        } else {
            String error = "Unrecognized model: " + model.getClass().getName();
            throw new IllegalArgumentException(error);
        }
        graph.add((Appliance)appliance);
        return appliance;
    }

    public String toString() {
        return "block:" + this.getModel().getQualifiedName();
    }
}

