/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.avalon.activation.appliance.Appliance;
import org.apache.avalon.activation.appliance.ApplianceException;
import org.apache.avalon.activation.appliance.BlockContext;
import org.apache.avalon.activation.appliance.Home;
import org.apache.avalon.activation.appliance.impl.AbstractBlock;
import org.apache.avalon.composition.data.ServiceDirective;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.framework.logger.Logger;

public class CompositeBlock
extends AbstractBlock
implements Home {
    private final BlockContext m_context;
    private final Object m_proxy;
    static /* synthetic */ Class class$java$lang$Object;

    CompositeBlock(BlockContext context) throws ApplianceException {
        super(context);
        this.m_context = context;
        try {
            Logger log = context.getLogger().getChildLogger("proxy");
            ContainmentModel model = context.getContainmentModel();
            BlockInvocationHandler handler = new BlockInvocationHandler(log, this);
            Class[] classes = this.getInterfaceClasses();
            this.m_proxy = Proxy.newProxyInstance(model.getClassLoaderModel().getClassLoader(), classes, (InvocationHandler)handler);
        }
        catch (Throwable e) {
            String error = "Composite service establishment failure in block: " + (Object)((Object)this);
            throw new ApplianceException(error, e);
        }
    }

    public Object resolve() throws Exception {
        return this.m_proxy;
    }

    public void release(Object instance) {
    }

    private Class[] getInterfaceClasses() throws Exception {
        ContainmentModel model = this.m_context.getContainmentModel();
        ClassLoader loader = model.getClassLoaderModel().getClassLoader();
        ArrayList list = new ArrayList();
        ServiceDirective[] services = model.getExportDirectives();
        for (int i = 0; i < services.length; ++i) {
            ServiceDirective service = services[i];
            String classname = service.getReference().getClassname();
            try {
                Class<?> clazz = loader.loadClass(classname);
                list.add(clazz);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                String error = "Class not found: [" + classname + "] in block [" + (Object)((Object)this) + "] with classloader content: \n";
                StringBuffer buffer = new StringBuffer(error);
                if (loader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)loader).getURLs();
                    for (int j = 0; j < urls.length; ++j) {
                        buffer.append("\n  " + urls[j].toString());
                    }
                }
                String message = buffer.toString();
                throw new ApplianceException(message);
            }
        }
        return list.toArray(new Class[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class BlockInvocationHandler
    implements InvocationHandler {
        private final CompositeBlock m_block;
        private final Logger m_logger;

        protected BlockInvocationHandler(Logger logger, CompositeBlock block) throws Exception {
            if (block == null) {
                throw new NullPointerException("block");
            }
            this.m_block = block;
            this.m_logger = logger;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (proxy == null) {
                throw new NullPointerException("proxy");
            }
            if (method == null) {
                throw new NullPointerException("method");
            }
            if (method.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = CompositeBlock.class$("java.lang.Object")) : class$java$lang$Object)) {
                this.m_logger.debug("invocation: " + method.getName());
                try {
                    return method.invoke((Object)this.m_block, args);
                }
                catch (InvocationTargetException e) {
                    String error = "Unexpected delegation error on java.lang.Object";
                    throw new ApplianceException("Unexpected delegation error on java.lang.Object", e.getTargetException());
                }
            }
            ContainmentModel model = CompositeBlock.this.m_context.getContainmentModel();
            ServiceDirective service = model.getExportDirective(method.getDeclaringClass());
            String path = service.getPath();
            Appliance provider = this.m_block.locate(path);
            this.m_logger.debug("delegating: " + method.getName());
            try {
                Object object = provider.resolve();
                return method.invoke(object, args);
            }
            catch (InvocationTargetException e) {
                String error = "Delegation error raised by provider: " + provider;
                throw new ApplianceException(error, e.getTargetException());
            }
            catch (Throwable e) {
                String error = "Composite service resolution failure for the class: '" + method.getDeclaringClass() + "' for operation: '" + method.getName() + "' in appliance: " + (Object)((Object)this.m_block);
                throw new ApplianceException(error, e);
            }
        }
    }
}

