/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.activation.appliance.Appliance;
import org.apache.avalon.activation.appliance.ApplianceRepository;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

class DefaultApplianceRepository
implements ApplianceRepository {
    private ApplianceRepository m_parent;
    private final Map m_appliances = new Hashtable();

    public DefaultApplianceRepository() {
        this.m_parent = null;
    }

    public DefaultApplianceRepository(ApplianceRepository parent) {
        this.m_parent = parent;
    }

    public Appliance getAppliance(DependencyDescriptor dependency) {
        Iterator iterator = this.m_appliances.values().iterator();
        while (iterator.hasNext()) {
            Appliance appliance = (Appliance)iterator.next();
            if (!appliance.getModel().isaCandidate(dependency)) continue;
            return appliance;
        }
        if (this.m_parent != null) {
            return this.m_parent.getAppliance(dependency);
        }
        return null;
    }

    public Appliance getAppliance(StageDescriptor stage) {
        Iterator iterator = this.m_appliances.values().iterator();
        while (iterator.hasNext()) {
            Appliance appliance = (Appliance)iterator.next();
            if (!appliance.isEnabled() || !appliance.getModel().isaCandidate(stage)) continue;
            return appliance;
        }
        if (this.m_parent != null) {
            return this.m_parent.getAppliance(stage);
        }
        return null;
    }

    protected void addAppliance(Appliance appliance) {
        this.m_appliances.put(appliance.getModel().getName(), appliance);
    }

    public Appliance[] getAppliances() {
        return this.m_appliances.values().toArray(new Appliance[0]);
    }

    public Appliance getLocalAppliance(String name) {
        return (Appliance)this.m_appliances.get(name);
    }
}

