/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.client.netty;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.netty.AbstractStampyNettyMessageGateway;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StampyLibrary(libraryName="stampy-NETTY-client-server-RI")
public class ClientNettyMessageGateway
extends AbstractStampyNettyMessageGateway {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NioClientSocketChannelFactory factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
    private String host;
    private Channel client;

    private ClientBootstrap init() {
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)this.factory);
        this.initializeChannel((Bootstrap)bootstrap);
        return bootstrap;
    }

    public void closeConnection(HostPort hostPort) {
        this.getHandler().close(hostPort);
    }

    public void connect() throws Exception {
        if (this.client == null) {
            ClientBootstrap bootstrap = this.init();
            ChannelFuture cf = bootstrap.connect((SocketAddress)new InetSocketAddress(this.getHost(), this.getPort()));
            cf.await();
            if (cf.isSuccess()) {
                this.client = cf.getChannel();
                log.info("Connected to {}:{}", (Object)this.getHost(), (Object)this.getPort());
            } else {
                log.error("Could not connect to {}:{}", (Object)this.getHost(), (Object)this.getPort());
            }
        } else if (this.client.isConnected()) {
            log.warn("Already connected");
        } else {
            log.error("Connector in unrecognized state: isBound {}, isConnected {}, ", (Object)this.client.isBound(), (Object)this.client.isConnected());
        }
    }

    public void shutdown() throws Exception {
        if (this.client == null || !this.client.isConnected()) {
            return;
        }
        ChannelFuture cf = this.client.close();
        cf.awaitUninterruptibly();
        this.client = null;
        log.info("Client has been shut down");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

