package com.hp.message.utils;

import java.util.UUID;

/**
 * 生成uuid工具
 *
 * @author mufeng
 */
public class UuidUtil {

    /**
     * 获取uuid
     *
     * @return
     */
    public static String getUuid() {
        return getUuid(false, false);
    }

    public static String getUuid(boolean toLower) {
        return getUuid(toLower, false);
    }

    /**
     * 获取uuid
     *
     * @param toLower          是否转化消息
     * @param withOutSplitChar 是否移除分隔符
     * @return
     */
    public static String getUuid(boolean toLower, boolean withOutSplitChar) {
        String resultStr = UUID.randomUUID().toString();
        if (withOutSplitChar){
            resultStr = resultStr.replace("-", "");
        }
        if (toLower){
            resultStr = resultStr.toLowerCase();
        } else {
            resultStr = resultStr.toUpperCase();
        }
        return resultStr;
    }

}
