package com.hp.message.utils;

import java.util.Arrays;

/**
 * @author 尚肖磊
 *  2021-03-12 15:11
 *  java对象与byte相互转换类
 */
public class CharConvertUtil {


    /**
     * 单字节转10进制字符串
     *
     * @param bData 单字节
     * @return 10进制字符串
     */
    public static String byteTo10String(byte bData) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        String hex = Integer.toString(bData & 0xFF);
        result.append(hex);
        result.append("]");
        return result.toString();
    }

    /**
     * bytes2HexString
     * <p>
     * 字节数组转10进制字符串
     *
     * @param bsData 字节数组
     * @return 10进制字符串
     */
    public static String bytes210String(byte[] bsData) {
        return Arrays.toString(bsData);
    }

    /**
     * 单字节转16进制字符串
     *
     * @param bData 单字节
     * @return 16进制字符串
     */
    public static String byteToHexString(byte bData) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        String hex = Integer.toHexString(bData & 0xFF);
        if (hex.length() == 1) {
            hex = '0' + hex;
        }
        result.append("0x");
        result.append(hex.toUpperCase());
        result.append("]");
        return result.toString();
    }

    /**
     * bytes2HexString
     * <p>
     * 字节数组转16进制字符串
     *
     * @param bsData 字节数组
     * @return 16进制字符串
     */
    public static String bytes2HexString(byte[] bsData) {
        return bytes2HexString(bsData, true, true);
    }
    public static String bytes2HexString(byte[] bsData, boolean enableHT, boolean enable0X) {
        StringBuffer result = new StringBuffer();
        if (enableHT) {
            result.append("[");
        }
        for (int i = 0; i < bsData.length; i++) {
            String hex = Integer.toHexString(bsData[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }

            if (enable0X) {
                if (i == 0) {
                    result.append("0x");
                } else {
                    result.append(" 0x");
                }
            }

            result.append(hex.toUpperCase());

            if (enable0X) {
                if (i != bsData.length - 1) {
                    result.append(",");
                }
            }
        }
        if (enableHT) {
            result.append("]");
        }
        return result.toString();
    }

    /**
     * 将16进制字符串 转换为byte数组
     *
     * @param hexString
     * @return 返回
     */
    public static byte[] hexStringToBytes(String hexString){
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; i++) {
            int pos = i * 2;
            d[i] = (byte) (charToByte(hexChars[pos]) << 4 | charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    /**
     * Convert char to byte
     * @param c char
     * @return byte
     */
    private static byte charToByte(char c) {
        return (byte) "0123456789ABCDEF".indexOf(c);
    }

    /**
     * 将byte 转换为 无符号整数
     *
     * @param b
     * @return 返回
     */
    public static int oneByte2Int(byte b) {
        return b & 0xFF;
    }

    /**
     * 将无符号整数 转换为 byte
     *
     * @param b
     * @return 返回
     */
    public static byte int2OneByte(int b) {
        return (byte) (b & 0x000000FF);
    }

    /**
     * 两个字节整数 与byte[] 之间的转换
     *
     * @param b
     * @param index
     * @return 返回
     */
    public static int twoBytes2Int(byte[] b, int index) {
        return (0x0000ff00 & (b[index + 0] << 8)) |
                (0x000000ff & b[index + 1]);
    }

    public static byte[] int2TwoBytes(int i) {
        byte[] b = new byte[2];
        b[0] = (byte) ((i & 0x0000ff00) >> 8);
        b[1] = (byte) (i & 0x000000ff);
        return b;
    }

}
