package com.hp.message.service.common;

import com.hp.message.event.BaseEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

/**
 * @author 尚肖磊
 *  2021-06-24 16:12
 *  内部事件发送服务类
 */
@Slf4j
@Service
public class InnerEventService {

    @Autowired
    private ApplicationEventPublisher eventPublisher;

    /**
     * 发送 内部消息
     *
     * @param event 消息对象
     * @return
     */
    public boolean publishEvent(BaseEvent event) {
        try {
            eventPublisher.publishEvent(event);
            return true;
        } catch (Exception ex) {
            log.error("publishEvent error", ex);
            return false;
        }
    }


}
