package com.hp.message.service;

import com.google.common.primitives.Bytes;
import com.hp.message.enums.EquiLogoutType;
import com.hp.message.interfaces.ISdkReceMsgService;
import com.hp.message.utils.CharConvertUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author 尚肖磊
 *  2021-06-25 14:15
 *  默认消息处理服务类
 */
@Slf4j
public class SdkReceMsgService implements ISdkReceMsgService {

    /**
     * 处理设备消息
     *
     * @param equiSno 设备标识
     * @return
     */
    @Override
    public boolean receEquiLoginMsg(String equiSno) {
        log.info("rece equi {} online msg", equiSno);
        return true;
    }

    /**
     * 处理设备离线消息
     *
     * @param equiSno    设备标识
     * @param equiLogoutType 离线原因
     * @return 返回
     */
    @Override
    public boolean receEquiLogoutMsg(String equiSno, EquiLogoutType equiLogoutType) {
        log.info("rece equi {} offline msg, reason {}", equiSno, equiLogoutType.getCodeDesc());
        return true;
    }

    /**
     * 接收到设备上报消息
     *
     * @param equiSno    设备标识
     * @param uploadData 上报数据对象
     * @return
     */
    @Override
    public boolean receEquiUploadDataMsg(String equiSno, List<Byte> uploadData) {
        byte[] receBytes = Bytes.toArray(uploadData);
        log.info("rece equi {} upload data msg {}", equiSno, CharConvertUtil.bytes2HexString(receBytes));
        return true;
    }

}
