package com.hp.message.service;

import com.hp.message.domain.ApiResp;
import com.hp.message.domain.param.AddEquiParam;
import com.hp.message.domain.result.*;
import com.hp.message.interfaces.IApiService;
import com.hp.message.interfaces.IRetrofitApiService;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author 尚肖磊
 * 2021-06-23 14:12
 * 对外公开api接口
 */
@Slf4j
public class ApiService implements IApiService {

    private IRetrofitApiService retrofitApiService;

    public ApiService(IRetrofitApiService retrofitApiService) {
        this.retrofitApiService = retrofitApiService;
    }


    /**
     * 新增项目接口
     *
     * @param projectName 项目名称
     * @param projectDesc 项目描述
     * @return
     */
    @Override
    public ApiResp addProject(String projectName, String projectDesc) {
        return retrofitApiService.addProject(projectName, projectDesc);
    }

    /**
     * 修改项目名称接口
     *
     * @param projectId   项目id
     * @param projectName 修改后项目名称
     * @return
     */
    @Override
    public ApiResp alterProject(int projectId, String projectName) {
        return retrofitApiService.alterProject(projectId, projectName);
    }

    /**
     * 删除项目
     *
     * @param projectId 项目id
     * @return
     */
    @Override
    public ApiResp removeProjectById(int projectId) {
        return retrofitApiService.removeProjectById(projectId);
    }

    /**
     * 获取应用 绑定项目列表接口
     *
     * @return
     */
    @Override
    public ApiResp<List<ProjectResult>> getAppProjectList() {
        return retrofitApiService.getAppProjectList();
    }

    /**
     * 修改项目透传状态接口
     *
     * @param projectId      项目id
     * @param enableTransfer 透传状态 true 开启 false 关闭
     * @return
     */
    @Override
    public ApiResp alterProjectTransferStatus(int projectId, boolean enableTransfer) {
        return retrofitApiService.alterProjectTransferStatus(projectId, enableTransfer);
    }

    /**
     * 解绑应用与项目接口
     *
     * @param projectId 项目id
     * @return
     */
    @Override
    public ApiResp unbindProject(int projectId) {
        return retrofitApiService.unbindProject(projectId);
    }

    /**
     * 获取分组列表接口
     *
     * @param projectId 项目id
     * @param groupName 查询分组名称(模糊匹配)
     * @return
     */
    @Override
    public ApiResp<List<GroupResult>> getGroupList(int projectId, String groupName) {
        return retrofitApiService.getGroupList(projectId, groupName);
    }

    /**
     * 创建项目分组接口
     *
     * @param projectId 项目id
     * @param groupName 项目分组名称
     * @param groupSort 项目分组排序值
     * @param groupDesc 项目分组描述
     * @return
     */
    @Override
    public ApiResp addGroup(int projectId, String groupName, int groupSort, String groupDesc) {
        return retrofitApiService.addGroup(projectId, groupName, groupSort, groupDesc);
    }

    /**
     * 修改项目分组接口
     *
     * @param groupId   项目分组id
     * @param groupName 项目分组名称
     * @param groupSort 项目分组排序值
     * @param groupDesc 项目分组描述
     * @return
     */
    @Override
    public ApiResp alterGroup(int groupId, String groupName, int groupSort, String groupDesc) {
        return retrofitApiService.alterGroup(groupId, groupName, groupSort, groupDesc);
    }

    /**
     * 删除项目分组
     *
     * @param groupId 项目分组id
     * @return
     */
    @Override
    public ApiResp removeGroupById(int groupId) {
        return retrofitApiService.removeGroupById(groupId);
    }


    /**
     * 获取设备详情接口(sno)
     *
     * @param equiSno 设备sno
     * @return
     */
    @Override
    public ApiResp getEquiInfoBySno(String equiSno) {
        return retrofitApiService.getEquiInfoBySno(equiSno);
    }

    /**
     * 获取设备详情接口
     *
     * @param equiSno 设备sno
     * @return
     */
    @Override
    public ApiResp<EquiResult> getEquiInfo(String equiSno) {
        return retrofitApiService.getEquiInfo(equiSno);
    }

    /**
     * 获取设备列表接口
     *
     * @param projectId      项目id
     * @param groupId        项目分组id
     * @param equiWorkStatus 设备状态(状态接口获取)
     * @param dataHandleType 数据处理方式(数据处理方式接口获取)
     * @return
     */
    @Override
    public ApiResp<List<EquiResult>> getEquiList(int projectId, int groupId, int equiWorkStatus, String dataHandleType) {
        return retrofitApiService.getEquiList(projectId, groupId, equiWorkStatus, dataHandleType);
    }

    /**
     * 获取设备状态列表接口
     *
     * @return
     */
    @Override
    public ApiResp<List<StatusResult>> getEquiWorkStatusList() {
        return retrofitApiService.getEquiWorkStatusList();
    }

    /**
     * 添加设备
     *
     * @param addEquiParam 注册设备JSON对象
     * @return
     */
    @Override
    public ApiResp<AddEquiResult> addEqui(AddEquiParam addEquiParam) {
        return retrofitApiService.addEqui(addEquiParam);
    }

    /**
     * 批量添加设备
     *
     * @param addEquiParamList 注册设备JSON对象列表
     * @return
     */
    @Override
    public ApiResp<List<AddEquiResult>> addEquiByList(List<AddEquiParam> addEquiParamList) {
        return retrofitApiService.addEquiByList(addEquiParamList);
    }

    /**
     * 修改设备信息接口
     *
     * @param equiSno      设备sno
     * @param projectId    项目id
     * @param groupId      分组id
     * @param equiName     设备名称
     * @param equiPassword 设备通讯密码
     * @return
     */
    @Override
    public ApiResp alterEquiBySno(String equiSno,
                                  int projectId,
                                  int groupId,
                                  String equiName,
                                  String equiPassword) {
        return retrofitApiService.alterEquiBySno(equiSno, projectId, groupId, equiName, equiPassword);
    }

    /**
     * 删除设备接口
     *
     * @param equiSno 设备sno
     * @return
     */
    @Override
    public ApiResp removeEquiBySno(String equiSno) {
        return retrofitApiService.removeEquiBySno(equiSno);
    }

    /**
     * 批量删除设备接口
     *
     * @param equiSnos 设备snos(格式 1,2,3,4)
     * @return
     */
    @Override
    public ApiResp removeEquiBySnos(String equiSnos) {
        return retrofitApiService.removeEquiBySnos(equiSnos);
    }

}
