package com.hp.message.property;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author 尚肖磊
 *  2021-06-24 18:12
 *  emqx参数配置类
 */

@Data
@ConfigurationProperties(prefix = MsgProperty.DEFAULT_PREFIX)
public class MsgProperty {
    public static final String DEFAULT_PREFIX = "hpiot.sdk.msg";

    /**
     * 消息服务地址 例如：tcp://emqx.hpiot.cn
     */
    private String msgHost = "tcp://emqx.hpiot.cn";

    /**
     * 连接 超时时间 默认30 单位秒
     */
    private Integer connectTimeout = 30;

    /**
     * 连接 心跳间隔 默认60 单位秒
     */
    private Integer keepAliveInterval = 60;

}
