package com.hp.message.property;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.hp.message.property.AppProperty.DEFAULT_PREFIX;

/**
 * @author 尚肖磊
 *  2021-06-18 14:59
 *  app参数配置类
 */

@Data
@ConfigurationProperties(value = DEFAULT_PREFIX)
public class AppProperty {
    public static final String DEFAULT_PREFIX = "hpiot.sdk.app";

    /**
     * 华普应用id
     */
    private String appId;

    /**
     * 华普应用key
     */
    private String appKey;

    /**
     * 华普应用secret
     */
    private String appSecret;

}
