package com.hp.message.interfaces;

import com.hp.message.enums.EquiLogoutType;

import java.util.List;

/**
 * @author 尚肖磊
 *  2021-06-25 14:06
 *   sdk接收消息接口类
 */
public interface ISdkReceMsgService {

    /**
     * 处理设备上线消息
     *
     * @param equiSno 设备标识
     * @return
     */
    boolean receEquiLoginMsg(String equiSno);

    /**
     * 处理设备离线消息
     *
     * @param equiSno    设备标识
     * @param equiLogoutType 离线原因
     * @return
     */
    boolean receEquiLogoutMsg(String equiSno, EquiLogoutType equiLogoutType);

    /**
     * 处理设备上报消息
     *
     * @param equiSno    设备标识
     * @param uploadData 上报数据对象
     * @return
     */
    boolean receEquiUploadDataMsg(String equiSno, List<Byte> uploadData);

}
