package com.hp.message.interfaces;

import com.hp.message.enums.MqMsgResultType;

/**
 * @author 尚肖磊
 *  2021-04-30 11:51
 *  sdk消息回调接口
 */
public interface ISdkMsgCallBack<T, V> {

    /**
     * 处理成功消息回调
     *
     * @param t 成功后回调对象t
     * @param v 成功处理消息后回调消息
     * @author 尚肖磊
     *  2020/3/4 18:52
     */
    void onSuccess(T t, V v);

    /**
     * 处理失败消息回调
     *
     * @param resultType 消息处理失败原因
     * @param v          失败后返回对象
     * @author 尚肖磊
     *  2020/3/4 18:52
     */
    void onError(MqMsgResultType resultType, V v);

    /**
     * 处理超时消息回调
     *
     * @param v 任务处理超时后返回对象
     * @author 尚肖磊
     *  2020/3/4 18:54
     */
    void onTimeout(V v);

}
