package com.hp.message.interfaces;

import com.hp.message.domain.ApiResp;
import com.hp.message.domain.param.AddEquiParam;
import com.hp.message.domain.result.*;

import java.util.List;

/**
 * @author 尚肖磊
 *  2021-06-23 14:10
 *  对外公开api接口
 */
public interface IApiService {

    /**
     * 新增项目接口
     *
     * @param projectName 项目名称
     * @param projectDesc 项目描述
     * @return
     */
    ApiResp addProject(String projectName, String projectDesc);

    /**
     * 获取应用 绑定项目列表接口
     *
     * @return
     */
    ApiResp<List<ProjectResult>> getAppProjectList();

    /**
     * 修改项目名称接口
     *
     * @param projectId   项目id
     * @param projectName 修改后项目名称
     * @return
     */
    ApiResp alterProject(int projectId, String projectName);

    /**
     * 删除项目
     *
     * @param projectId 项目id
     * @return
     */
    ApiResp removeProjectById(int projectId);

    /**
     * 修改项目透传状态接口
     *
     * @param projectId      项目id
     * @param enableTransfer 透传状态 true 开启 false 关闭
     * @return
     */
    ApiResp alterProjectTransferStatus(int projectId, boolean enableTransfer);

    /**
     * 解绑应用与项目接口
     *
     * @param projectId 项目id
     * @return
     */
    ApiResp unbindProject(int projectId);

    /**
     * 获取分组列表接口
     *
     * @param projectId 项目id
     * @param groupName 查询分组名称(模糊匹配)
     * @return
     */
    ApiResp<List<GroupResult>> getGroupList(int projectId, String groupName);

    /**
     * 创建项目分组接口
     *
     * @param projectId 项目id
     * @param groupName 项目分组名称
     * @param groupSort 项目分组排序值
     * @param groupDesc 项目分组描述
     * @return
     */
    ApiResp addGroup(int projectId, String groupName, int groupSort, String groupDesc);

    /**
     * 修改项目分组接口
     *
     * @param groupId   项目分组id
     * @param groupName 项目分组名称
     * @param groupSort 项目分组排序值
     * @param groupDesc 项目分组描述
     * @return
     */
    ApiResp alterGroup(int groupId, String groupName, int groupSort, String groupDesc);

    /**
     * 删除项目分组
     *
     * @param groupId 项目分组id
     * @return
     */
    ApiResp removeGroupById(int groupId);


    /**
     * 获取设备详情
     *
     * @param equiSno
     * @return
     */

    ApiResp getEquiInfoBySno(String equiSno);

    /**
     * 获取设备详情接口
     *
     * @param equiSno 设备sno
     * @return
     */
    ApiResp<EquiResult> getEquiInfo(String equiSno);

    /**
     * 获取设备列表接口
     *
     * @param projectId      项目id
     * @param groupId        项目分组id
     * @param equiWorkStatus 设备状态(状态接口获取)
     * @param dataHandleType 数据处理方式(数据处理方式接口获取)
     * @return
     */
    ApiResp<List<EquiResult>> getEquiList(int projectId, int groupId, int equiWorkStatus, String dataHandleType);

    /**
     * 获取设备状态列表接口
     *
     * @return
     */
    ApiResp<List<StatusResult>> getEquiWorkStatusList();

    /**
     * 注册(添加)设备
     *
     * @param addEquiParam 注册设备JSON对象
     * @return
     */
    ApiResp<AddEquiResult> addEqui(AddEquiParam addEquiParam);

    /**
     * 批量注册(添加)设备
     *
     * @param addEquiParamList 注册设备JSON对象列表
     * @return
     */
    ApiResp<List<AddEquiResult>> addEquiByList(List<AddEquiParam> addEquiParamList);

    /**
     * 修改设备信息接口
     *
     * @param equiSno      设备sno
     * @param projectId    项目id
     * @param groupId      分组id
     * @param equiName     设备名称
     * @param equiPassword 设备通讯密码
     * @return
     */
    ApiResp alterEquiBySno(String equiSno, int projectId, int groupId, String equiName, String equiPassword);

    /**
     * 删除设备接口
     *
     * @param equiSno 设备sno
     * @return
     */
    ApiResp removeEquiBySno(String equiSno);

    /**
     * 批量删除设备接口
     *
     * @param equiSnos 设备snos(格式 1,2,3,4)
     * @return
     */
    ApiResp removeEquiBySnos(String equiSnos);

}
