package com.hp.message.event;


import com.hp.message.domain.EmqxDataMsg;
import com.hp.message.enums.EmqxQosType;

/**
 * @author 尚肖磊
 *  2021-05-25 9:58
 *  发送 emqxmq 消息事件
 */
public class EmqxSendMsgEvent extends BaseEvent<EmqxDataMsg> {

    /**
     * 发送消息主题
     */
    private String emqxTopic;

    /**
     * 消息qos类型
     */
    private EmqxQosType qosType;

    public EmqxSendMsgEvent(Object source, EmqxDataMsg eventData, String emqxTopic) {
        super(source, eventData);
        this.emqxTopic = emqxTopic;
        this.qosType = EmqxQosType.QOS_0;
    }

    public EmqxSendMsgEvent(Object source, EmqxDataMsg eventData, String emqxTopic, EmqxQosType qosType) {
        super(source, eventData);
        this.emqxTopic = emqxTopic;
        this.qosType = qosType;
    }

    public String getEmqxTopic() {
        return emqxTopic;
    }

    public void setEmqxTopic(String emqxTopic) {
        this.emqxTopic = emqxTopic;
    }

    public EmqxQosType getQosType() {
        return qosType;
    }

    public void setQosType(EmqxQosType qosType) {
        this.qosType = qosType;
    }
}
