package com.hp.message.event;


import com.hp.message.domain.EmqxDataMsg;

/**
 * @author 尚肖磊
 *  2021-08-26 14:20
 *  emqx发送消息完成事件类
 */
public class EmqxPushMsgEvent extends BaseEvent<EmqxDataMsg> {

    /**
     * 发送消息主题
     */
    private String emqxTopic;

    /**
     * 构造事件对象
     *
     * @param source    消息来源对象
     * @param eventData 事件数据对象
     */
    public EmqxPushMsgEvent(Object source, EmqxDataMsg eventData, String emqxTopic) {
        super(source, eventData);
        this.emqxTopic = emqxTopic;
    }

    public String getEmqxTopic() {
        return emqxTopic;
    }

    public void setEmqxTopic(String emqxTopic) {
        this.emqxTopic = emqxTopic;
    }
}
